/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator;

import io.apptik.json.JsonElement;
import io.apptik.json.generator.JsonGeneratorConfig;
import io.apptik.json.generator.generators.ArrayGenerator;
import io.apptik.json.generator.generators.BooleanGenerator;
import io.apptik.json.generator.generators.EnumGenerator;
import io.apptik.json.generator.generators.IntegerGenerator;
import io.apptik.json.generator.generators.LimitedNumberGenerator;
import io.apptik.json.generator.generators.NumberGenerator;
import io.apptik.json.generator.generators.ObjectGenerator;
import io.apptik.json.generator.generators.RangeGenerator;
import io.apptik.json.generator.generators.StringGenerator;
import io.apptik.json.generator.matcher.SchemaCompositeMatchers;
import io.apptik.json.generator.matcher.SchemaDefMatchers;
import io.apptik.json.schema.Schema;
import io.apptik.json.schema.SchemaList;
import io.apptik.json.util.LinkedTreeMap;
import io.apptik.json.wrapper.JsonObjectWrapper;
import java.util.Random;
import org.hamcrest.Matcher;

public class JsonGenerator {
    protected Schema schema;
    protected JsonGeneratorConfig configuration;
    protected String propertyName;
    protected static Random rnd = new Random();
    protected static LinkedTreeMap<Matcher<Schema>, Class> commonPropertyMatchers = new LinkedTreeMap();

    public JsonGenerator(Schema schema, JsonGeneratorConfig configuration) {
        this.schema = schema;
        this.configuration = configuration;
        if (this.configuration == null) {
            this.configuration = new JsonGeneratorConfig();
        }
        schema.mergeAllRefs();
        this.mergeComposites();
    }

    public JsonGenerator(Schema schema, JsonGeneratorConfig configuration, String propertyName) {
        this(schema, configuration);
        this.propertyName = propertyName;
        schema.mergeAllRefs();
        this.mergeComposites();
    }

    private void mergeComposites() {
        this.mergeOneOf();
        this.mergeAllOf();
        this.mergeAnyOf();
    }

    private void mergeOneOf() {
        if (SchemaCompositeMatchers.hasOneOf().matches((Object)this.schema)) {
            SchemaList list = this.schema.getOneOf();
            Schema choice = (Schema)list.get(rnd.nextInt(list.size()));
            this.schema.getJson().remove("oneOf");
            this.schema.merge((JsonObjectWrapper)choice);
        }
    }

    private void mergeAnyOf() {
        if (SchemaCompositeMatchers.hasAnyOf().matches((Object)this.schema)) {
            SchemaList list = this.schema.getAnyOf();
            Schema choice = (Schema)list.get(rnd.nextInt(list.size()));
            this.schema.getJson().remove("anyOf");
            this.schema.merge((JsonObjectWrapper)choice);
        }
    }

    private void mergeAllOf() {
        if (SchemaCompositeMatchers.hasAllOf().matches((Object)this.schema)) {
            SchemaList list = this.schema.getAllOf();
            this.schema.getJson().remove("allOf");
            for (Schema subSchema : list) {
                this.schema.merge((JsonObjectWrapper)subSchema);
            }
        }
    }

    public JsonElement generate() {
        if (((String)this.schema.getType().get(0)).equals("object")) {
            return new ObjectGenerator(this.schema, this.configuration).generate();
        }
        if (((String)this.schema.getType().get(0)).equals("array")) {
            return new ArrayGenerator(this.schema, this.configuration).generate();
        }
        throw new UnsupportedOperationException("Use Main generator only for full valid JSON object or array.");
    }

    static {
        commonPropertyMatchers.put(SchemaDefMatchers.isEnum(), EnumGenerator.class);
        commonPropertyMatchers.put(SchemaDefMatchers.isStringType(), StringGenerator.class);
        commonPropertyMatchers.put(SchemaDefMatchers.isBooleanType(), BooleanGenerator.class);
        commonPropertyMatchers.put(SchemaDefMatchers.isLimitedNumber(), LimitedNumberGenerator.class);
        commonPropertyMatchers.put(SchemaDefMatchers.isIntegerType(), IntegerGenerator.class);
        commonPropertyMatchers.put(SchemaDefMatchers.isNumberType(), NumberGenerator.class);
        commonPropertyMatchers.put(SchemaDefMatchers.isRangeObject(), RangeGenerator.class);
        commonPropertyMatchers.put(SchemaDefMatchers.isObjectType(), ObjectGenerator.class);
        commonPropertyMatchers.put(SchemaDefMatchers.isArrayType(), ArrayGenerator.class);
    }
}

