/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.generators;

import io.apptik.json.JsonElement;
import io.apptik.json.JsonNumber;
import io.apptik.json.generator.JsonGenerator;
import io.apptik.json.generator.JsonGeneratorConfig;
import io.apptik.json.schema.Schema;

public class IntegerGenerator
extends JsonGenerator {
    public IntegerGenerator(Schema schema, JsonGeneratorConfig configuration) {
        super(schema, configuration);
    }

    public IntegerGenerator(Schema schema, JsonGeneratorConfig configuration, String propertyName) {
        super(schema, configuration, propertyName);
    }

    @Override
    public JsonElement generate() {
        int minValue = 0;
        int maxValue = Integer.MAX_VALUE;
        if (this.configuration != null) {
            if (this.configuration.globalIntegerMin != null) {
                minValue = this.configuration.globalIntegerMin;
            }
            if (this.configuration.globalIntegerMax != null) {
                maxValue = this.configuration.globalIntegerMax;
            }
            if (this.propertyName != null) {
                if (this.configuration.integerMin.get(this.propertyName) != null) {
                    minValue = this.configuration.integerMin.get(this.propertyName);
                }
                if (this.configuration.integerMax.get(this.propertyName) != null) {
                    maxValue = this.configuration.integerMax.get(this.propertyName);
                }
            }
        }
        return new JsonNumber((Number)(minValue + rnd.nextInt(maxValue - minValue)));
    }
}

