/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.generators;

import io.apptik.json.JsonElement;
import io.apptik.json.JsonString;
import io.apptik.json.generator.JsonGenerator;
import io.apptik.json.generator.JsonGeneratorConfig;
import io.apptik.json.generator.generators.formats.DateGenerator;
import io.apptik.json.generator.generators.formats.DateTimeGenerator;
import io.apptik.json.generator.generators.formats.EmailGenerator;
import io.apptik.json.generator.generators.formats.TimeGenerator;
import io.apptik.json.generator.generators.formats.UriGenerator;
import io.apptik.json.generator.matcher.FormatMatchers;
import io.apptik.json.schema.Schema;
import io.apptik.json.util.LinkedTreeMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.hamcrest.Matcher;

public class StringGenerator
extends JsonGenerator {
    protected static LinkedTreeMap<Matcher<Schema>, Class> stringFormatMatchers = new LinkedTreeMap();

    public StringGenerator(Schema schema, JsonGeneratorConfig configuration) {
        super(schema, configuration);
    }

    public StringGenerator(Schema schema, JsonGeneratorConfig configuration, String propertyName) {
        super(schema, configuration, propertyName);
    }

    @Override
    public JsonElement generate() {
        int minChars = 0;
        int maxChars = 15;
        if (this.schema.getFormat() != null) {
            for (Map.Entry entry : stringFormatMatchers.entrySet()) {
                if (!((Matcher)entry.getKey()).matches((Object)this.schema)) continue;
                JsonGenerator gen = null;
                try {
                    gen = (JsonGenerator)((Class)entry.getValue()).getDeclaredConstructor(Schema.class, JsonGeneratorConfig.class, String.class).newInstance(this.schema, this.configuration, this.propertyName);
                    return gen.generate();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        if (this.configuration != null) {
            if (this.configuration.globalStringLengthMin != null) {
                minChars = this.configuration.globalStringLengthMin;
            }
            if (this.configuration.globalStringLengthMax != null) {
                maxChars = this.configuration.globalStringLengthMax;
            }
            if (this.propertyName != null) {
                if (this.configuration.stringLengthMin.get(this.propertyName) != null) {
                    minChars = this.configuration.stringLengthMin.get(this.propertyName);
                }
                if (this.configuration.stringLengthMax.get(this.propertyName) != null) {
                    maxChars = this.configuration.stringLengthMax.get(this.propertyName);
                }
                if (this.configuration.stringPredefinedValues.get(this.propertyName) != null) {
                    return new JsonString(this.configuration.stringPredefinedValues.get(this.propertyName).get(rnd.nextInt(this.configuration.stringPredefinedValues.get(this.propertyName).size())));
                }
            }
        }
        String res = "";
        int cnt = minChars + rnd.nextInt(maxChars - minChars);
        for (int i = 0; i < cnt; ++i) {
            res = res + (rnd.nextBoolean() ? (char)(65 + rnd.nextInt(25)) : (char)(97 + rnd.nextInt(25)));
        }
        return new JsonString(res);
    }

    static {
        stringFormatMatchers.put(FormatMatchers.isDateTimeFormat(), DateTimeGenerator.class);
        stringFormatMatchers.put(FormatMatchers.isDateFormat(), DateGenerator.class);
        stringFormatMatchers.put(FormatMatchers.isTimeFormat(), TimeGenerator.class);
        stringFormatMatchers.put(FormatMatchers.isUriFormat(), UriGenerator.class);
        stringFormatMatchers.put(FormatMatchers.isEmailFormat(), EmailGenerator.class);
    }
}

