/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.generators.formats;

import io.apptik.json.JsonElement;
import io.apptik.json.JsonString;
import io.apptik.json.generator.JsonGenerator;
import io.apptik.json.generator.JsonGeneratorConfig;
import io.apptik.json.schema.Schema;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class UriGenerator
extends JsonGenerator {
    public UriGenerator(Schema schema, JsonGeneratorConfig configuration) {
        super(schema, configuration);
    }

    public UriGenerator(Schema schema, JsonGeneratorConfig configuration, String propertyName) {
        super(schema, configuration, propertyName);
    }

    @Override
    public JsonElement generate() {
        URI uri;
        ArrayList<Object> paths;
        ArrayList<Object> hosts;
        ArrayList<Object> schemes;
        if (this.configuration != null && this.propertyName != null && this.configuration.uriSchemes.get(this.propertyName) != null && this.configuration.uriSchemes.get(this.propertyName).size() > 0) {
            schemes = this.configuration.uriSchemes.get(this.propertyName);
        } else if (this.configuration != null && this.configuration.globalUriSchemes != null && this.configuration.globalUriSchemes.size() > 0) {
            schemes = this.configuration.globalUriSchemes;
        } else {
            schemes = new ArrayList<String>();
            schemes.add("http");
            schemes.add("https");
            schemes.add("ftp");
            schemes.add("file");
            schemes.add("resource");
            schemes.add(null);
        }
        if (this.configuration != null && this.propertyName != null && this.configuration.uriHosts.get(this.propertyName) != null && this.configuration.uriHosts.get(this.propertyName).size() > 0) {
            hosts = this.configuration.uriHosts.get(this.propertyName);
        } else if (this.configuration != null && this.configuration.globalUriHosts != null & this.configuration.globalUriHosts.size() > 0) {
            hosts = this.configuration.globalUriHosts;
        } else {
            hosts = new ArrayList<String>();
            hosts.add("google.com");
            hosts.add("yahoo.com");
            hosts.add("bing.com");
            hosts.add("djodjo.org");
            hosts.add(null);
        }
        if (this.configuration != null && this.propertyName != null && this.configuration.uriPaths.get(this.propertyName) != null && this.configuration.uriPaths.get(this.propertyName).size() > 0) {
            paths = this.configuration.uriPaths.get(this.propertyName);
        } else if (this.configuration != null && this.configuration.globalUriPaths != null && this.configuration.globalUriPaths.size() > 0) {
            paths = this.configuration.globalUriPaths;
        } else {
            int i;
            int cnt;
            paths = new ArrayList();
            int pathMinLen = 3;
            int pathMaxLen = rnd.nextInt(33);
            if (this.configuration != null) {
                if (this.configuration.globalUriPathLengthMin != null) {
                    pathMinLen = this.configuration.globalUriPathLengthMin;
                }
                if (this.configuration.globalUriPathLengthMax != null) {
                    pathMaxLen = this.configuration.globalUriPathLengthMax;
                }
                if (this.propertyName != null) {
                    if (this.configuration.uriPathLengthMin.get(this.propertyName) != null) {
                        pathMinLen = this.configuration.uriPathLengthMin.get(this.propertyName);
                    }
                    if (this.configuration.uriPathLengthMax.get(this.propertyName) != null) {
                        pathMaxLen = this.configuration.uriPathLengthMax.get(this.propertyName);
                    }
                }
            }
            String res = "";
            if (pathMaxLen > 0) {
                res = "/";
                cnt = pathMinLen;
                for (i = 0; i < cnt; ++i) {
                    res = res + (rnd.nextBoolean() ? (char)(65 + rnd.nextInt(25)) : (char)(97 + rnd.nextInt(25)));
                }
            }
            while (res.length() < pathMaxLen) {
                res = res + "/";
                cnt = rnd.nextInt(7);
                for (i = 0; i < cnt && res.length() < pathMaxLen; ++i) {
                    res = res + (rnd.nextBoolean() ? (char)(65 + rnd.nextInt(25)) : (char)(97 + rnd.nextInt(25)));
                }
            }
            paths.add(res);
        }
        String scheme = (String)schemes.get(rnd.nextInt(schemes.size()));
        String host = (String)hosts.get(rnd.nextInt(hosts.size()));
        String path = paths.size() == 1 ? (String)paths.get(0) : (String)paths.get(rnd.nextInt(paths.size()));
        try {
            uri = new URI(scheme, host, path, null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new RuntimeException("We must not be here!");
        }
        return new JsonString(uri.toString());
    }
}

