/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.matcher;

import io.apptik.json.generator.matcher.ComparableTypeSafeMatcher;
import io.apptik.json.schema.Schema;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class SchemaCompositeMatchers {
    private SchemaCompositeMatchers() {
    }

    public static Matcher<Schema> hasAnyOf() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                return item.getAnyOf() != null && item.getAnyOf().isEmpty();
            }

            public void describeTo(Description description) {
                description.appendText("Has anyOf section");
            }
        };
    }

    public static Matcher<Schema> hasOneOf() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                return item.getOneOf() != null && !item.getOneOf().isEmpty();
            }

            public void describeTo(Description description) {
                description.appendText("Has anyOf section");
            }
        };
    }

    public static Matcher<Schema> hasAllOf() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                return item.getAllOf() != null && item.getAllOf().isEmpty();
            }

            public void describeTo(Description description) {
                description.appendText("Has anyOf section");
            }
        };
    }
}

