/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.matcher;

import io.apptik.json.generator.matcher.ComparableTypeSafeMatcher;
import io.apptik.json.schema.Schema;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class SchemaDefMatchers {
    private SchemaDefMatchers() {
    }

    public static Matcher<Schema> isObjectType() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (item.getType() == null) {
                    return false;
                }
                return item.getType().contains("object");
            }

            public void describeTo(Description description) {
                description.appendText("is Object type");
            }
        };
    }

    public static Matcher<Schema> isArrayType() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (item.getType() == null) {
                    return false;
                }
                return item.getType().contains("array");
            }

            public void describeTo(Description description) {
                description.appendText("is Array type");
            }
        };
    }

    public static Matcher<Schema> isStringType() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (item.getType() == null) {
                    return false;
                }
                return item.getType().contains("string");
            }

            public void describeTo(Description description) {
                description.appendText("is String type");
            }
        };
    }

    public static Matcher<Schema> isNumberType() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (item.getType() == null) {
                    return false;
                }
                return item.getType().contains("number") || SchemaDefMatchers.isIntegerType().matches((Object)item);
            }

            public void describeTo(Description description) {
                description.appendText("is Number type");
            }
        };
    }

    public static Matcher<Schema> isIntegerType() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (item.getType() == null) {
                    return false;
                }
                return item.getType().contains("integer");
            }

            public void describeTo(Description description) {
                description.appendText("is Integer type");
            }
        };
    }

    public static Matcher<Schema> isLimitedNumber() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isNumberType().matches((Object)item)) {
                    return false;
                }
                return item.getMinimum() != null || item.getMaximum() != null;
            }

            public void describeTo(Description description) {
                description.appendText("is Limited Number");
            }
        };
    }

    public static Matcher<Schema> isBooleanType() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (item.getType() == null) {
                    return false;
                }
                return item.getType().contains("boolean");
            }

            public void describeTo(Description description) {
                description.appendText("is Boolean type");
            }
        };
    }

    public static Matcher<Schema> isEnum() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (item.getEnum() == null) {
                    return false;
                }
                return item.getEnum().length() != 0;
            }

            public void describeTo(Description description) {
                description.appendText("is enum");
            }
        };
    }

    public static Matcher<Schema> isRangeObject() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isObjectType().matches((Object)item)) {
                    return false;
                }
                if (item.getProperties() == null) {
                    return false;
                }
                if (item.getProperties().length() != 2) {
                    return false;
                }
                if (item.getProperties().optValue("min") == null) {
                    return false;
                }
                if (item.getProperties().optValue("max") == null) {
                    return false;
                }
                if (!SchemaDefMatchers.isNumberType().matches(item.getProperties().optValue("min"))) {
                    return false;
                }
                return SchemaDefMatchers.isNumberType().matches(item.getProperties().optValue("max"));
            }

            public void describeTo(Description description) {
                description.appendText("is Range Object");
            }
        };
    }

    public static Matcher<Schema> isLimitedRangeObject() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isRangeObject().matches((Object)item)) {
                    return false;
                }
                if (Double.compare(((Schema)item.getProperties().optValue("min")).getMinimum(), Double.NaN) == 0) {
                    return false;
                }
                return Double.compare(((Schema)item.getProperties().optValue("max")).getMaximum(), Double.NaN) != 0;
            }

            public void describeTo(Description description) {
                description.appendText("is Limited Range Object");
            }
        };
    }
}

