/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.schema;

import io.apptik.json.JsonArray;
import io.apptik.json.JsonElement;
import io.apptik.json.JsonObject;
import io.apptik.json.Validator;
import io.apptik.json.schema.SchemaList;
import io.apptik.json.schema.SchemaMap;
import io.apptik.json.schema.fetch.SchemaFetcher;
import io.apptik.json.schema.fetch.SchemaUriFetcher;
import io.apptik.json.wrapper.JsonElementWrapper;
import io.apptik.json.wrapper.JsonObjectWrapper;
import io.apptik.json.wrapper.JsonStringArrayWrapper;
import io.apptik.json.wrapper.MetaInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Schema
extends JsonObjectWrapper
implements MetaInfo {
    public static final String VER_4 = "http://json-schema.org/draft-04/schema#";
    public static final String VER_5 = "http://json-schema.org/draft-05/schema#";
    public static final String FORMAT_DATE_TIME = "date-time";
    public static final String FORMAT_DATE = "date";
    public static final String FORMAT_TIME = "time";
    public static final String FORMAT_UTC_MILISEC = "utc-millisec";
    public static final String FORMAT_REGEX = "regex";
    public static final String FORMAT_COLOR = "color";
    public static final String FORMAT_STYLE = "style";
    public static final String FORMAT_PHONE = "phone";
    public static final String FORMAT_URI = "uri";
    public static final String FORMAT_EMAIL = "email";
    public static final String FORMAT_IP_ADDR = "ip-address";
    public static final String FORMAT_IPV4 = "ipv4";
    public static final String FORMAT_IPV6 = "ipv6";
    public static final String FORMAT_HOST_NAME = "host-name";
    public static final String FORMAT_HOSTNAME = "hostname";
    protected URI origSrc = null;
    protected SchemaFetcher schemaFetcher = null;

    public Schema() {
        this.setContentType("application/schema+json");
    }

    public Schema(URI schemaRef) {
        this();
        this.origSrc = schemaRef;
        this.wrap(new SchemaUriFetcher().fetch(this.origSrc, null, null).getJson());
    }

    public SchemaFetcher getSchemaFetcher() {
        return this.schemaFetcher;
    }

    public <O extends Schema> O setSchemaFetcher(SchemaFetcher schemaFetcher) {
        this.schemaFetcher = schemaFetcher;
        return (O)((Object)this);
    }

    public <O extends Schema> O setOrigSrc(URI origSrc) {
        this.origSrc = origSrc;
        return (O)((Object)this);
    }

    public URI getOrigSrc() {
        return this.origSrc;
    }

    public abstract Schema getEmptySchema(String var1);

    public JsonElementWrapper setMetaInfoUri(URI uri) {
        throw new RuntimeException("Cannot set Schema on a Schema like this. Use setSchema method.");
    }

    public <T extends JsonElementWrapper> T wrap(JsonObject jsonElement) {
        Schema schema = (Schema)super.wrap((JsonElement)jsonElement);
        this.mergeWithRef();
        return (T)((Object)schema);
    }

    public Schema mergeAllRefs() {
        Object vals;
        Iterator iterator;
        if (this.getItems() != null) {
            iterator = this.getItems().iterator();
            while (iterator.hasNext()) {
                vals = (Schema)((Object)iterator.next());
                ((Schema)((Object)vals)).mergeAllRefs();
            }
        }
        if (this.getProperties() != null) {
            iterator = this.getProperties().iterator();
            while (iterator.hasNext()) {
                vals = (Map.Entry)iterator.next();
                ((Schema)((Object)vals.getValue())).mergeAllRefs();
            }
        }
        if (this.getPatternProperties() != null) {
            iterator = this.getPatternProperties().iterator();
            while (iterator.hasNext()) {
                vals = (Map.Entry)iterator.next();
                ((Schema)((Object)vals.getValue())).mergeAllRefs();
            }
        }
        if (this.getOneOf() != null) {
            iterator = this.getOneOf().iterator();
            while (iterator.hasNext()) {
                vals = (Schema)((Object)iterator.next());
                ((Schema)((Object)vals)).mergeAllRefs();
            }
        }
        if (this.getAllOf() != null) {
            iterator = this.getAllOf().iterator();
            while (iterator.hasNext()) {
                vals = (Schema)((Object)iterator.next());
                ((Schema)((Object)vals)).mergeAllRefs();
            }
        }
        if (this.getAnyOf() != null) {
            iterator = this.getAnyOf().iterator();
            while (iterator.hasNext()) {
                vals = (Schema)((Object)iterator.next());
                ((Schema)((Object)vals)).mergeAllRefs();
            }
        }
        if (this.getNot() != null) {
            this.getNot().mergeAllRefs();
        }
        return this;
    }

    private void mergeWithRef() {
        if (this.getRef() != null && !this.getRef().trim().isEmpty()) {
            Schema refSchema;
            if (this.schemaFetcher == null) {
                this.schemaFetcher = new SchemaUriFetcher();
            }
            if ((refSchema = this.schemaFetcher.fetch(URI.create(this.getRef()), this.origSrc, URI.create(this.getId()))) != null) {
                this.setOrigSrc(refSchema.origSrc);
                this.setSchemaFetcher(refSchema.getSchemaFetcher());
                String oldTitle = this.getTitle();
                String oldDesc = this.getDescription();
                this.getJson().clear();
                this.merge(refSchema);
                this.getJson().put("title", (Object)oldTitle).put("description", (Object)oldDesc);
            }
        }
    }

    public URI getJsonSchemaUri() {
        return URI.create(this.getSchema());
    }

    public Validator getDefaultValidator() {
        return null;
    }

    public String getId() {
        return this.getJson().optString("id", "");
    }

    public <O extends Schema> O setId(String schemaId) {
        this.getJson().put("id", (Object)schemaId);
        return (O)((Object)this);
    }

    protected Schema setSchema(String schemaUri) {
        this.getJson().put("$schema", (Object)schemaUri);
        return this;
    }

    public String getSchema() {
        return this.getJson().optString("$schema", "");
    }

    public String getRef() {
        return this.getJson().optString("$ref", "");
    }

    public String getTitle() {
        return this.getJson().optString("title", "");
    }

    public String getFormat() {
        return this.getJson().optString("format", "");
    }

    public String getDescription() {
        return this.getJson().optString("description", "");
    }

    public String getDefault() {
        return this.getJson().optString("default", "");
    }

    public Double getMultipleOf() {
        return this.getJson().optDouble("multipleOf");
    }

    public Double getMaximum() {
        return this.getJson().optDouble("maximum");
    }

    public boolean getExclusiveMaximum() {
        return this.getJson().optBoolean("exclusiveMaximum", Boolean.valueOf(false));
    }

    public Double getMinimum() {
        return this.getJson().optDouble("minimum");
    }

    public boolean getExclusiveMinimum() {
        return this.getJson().optBoolean("exclusiveMinimum", Boolean.valueOf(false));
    }

    public Integer getMaxLength() {
        return this.getJson().optInt("maxLength");
    }

    public Integer getMinLength() {
        return this.getJson().optInt("minLength");
    }

    public String getPattern() {
        return this.getJson().optString("pattern", "");
    }

    public boolean getAdditionalItems() {
        return this.getJson().optBoolean("additionalItems", Boolean.valueOf(true));
    }

    public SchemaList getItems() {
        if (this.getJson().opt("items") == null) {
            return null;
        }
        if (this.getJson().opt("items").isJsonArray()) {
            return (SchemaList)new SchemaList(this.getEmptySchema("items")).wrap(this.getJson().optJsonArray("items"));
        }
        SchemaList res = new SchemaList(this.getEmptySchema("items"));
        res.add((Object)((Schema)((Object)this.getEmptySchema("items/0").wrap(this.getJson().optJsonObject("items")))));
        return res;
    }

    public Integer getMaxItems() {
        return this.getJson().optInt("maxItems");
    }

    public Integer getMinItems() {
        return this.getJson().optInt("minItems");
    }

    public boolean getUniqueItems() {
        return this.getJson().optBoolean("uniqueItems", Boolean.valueOf(false));
    }

    public Integer getMaxProperties() {
        return this.getJson().optInt("maxProperties");
    }

    public Integer getMinProperties() {
        return this.getJson().optInt("minProperties");
    }

    public List<String> getRequired() {
        return new JsonStringArrayWrapper().wrap(this.getJson().optJsonArray("required"));
    }

    public boolean getAdditionalProperties() {
        return this.getJson().optBoolean("additionalProperties", Boolean.valueOf(true));
    }

    public JsonObject getDefinitions() {
        return this.getJson().optJsonObject("definitions");
    }

    public SchemaMap getProperties() {
        if (!this.getJson().has("properties")) {
            return null;
        }
        return (SchemaMap)new SchemaMap(this.getEmptySchema("properties")).wrap((JsonElement)this.getJson().optJsonObject("properties"));
    }

    public SchemaMap getPatternProperties() {
        return (SchemaMap)new SchemaMap(this.getEmptySchema("patternProperties")).wrap((JsonElement)this.getJson().optJsonObject("patternProperties"));
    }

    public JsonObject getDependencies() {
        return this.getJson().optJsonObject("dependencies");
    }

    public JsonArray getEnum() {
        return this.getJson().optJsonArray("enum");
    }

    public List<String> getType() {
        if (this.getJson().opt("type") == null) {
            return null;
        }
        if (this.getJson().opt("type").isJsonArray()) {
            return new JsonStringArrayWrapper().wrap(this.getJson().optJsonArray("type"));
        }
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.getJson().optString("type"));
        return res;
    }

    public SchemaList getAllOf() {
        if (!this.getJson().has("allOf")) {
            return null;
        }
        return (SchemaList)new SchemaList(this.getEmptySchema("allOf")).wrap(this.getJson().optJsonArray("allOf"));
    }

    public SchemaList getAnyOf() {
        if (!this.getJson().has("anyOf")) {
            return null;
        }
        return (SchemaList)new SchemaList(this.getEmptySchema("anyOf")).wrap(this.getJson().optJsonArray("anyOf"));
    }

    public SchemaList getOneOf() {
        if (!this.getJson().has("oneOf")) {
            return null;
        }
        return (SchemaList)new SchemaList(this.getEmptySchema("oneOf")).wrap(this.getJson().optJsonArray("oneOf"));
    }

    public Schema getNot() {
        if (!this.getJson().has("not")) {
            return null;
        }
        return (Schema)((Object)this.getEmptySchema("not").wrap(this.getJson().optJsonObject("not")));
    }
}

