/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.schema.fetch;

import io.apptik.json.JsonElement;
import io.apptik.json.JsonObject;
import io.apptik.json.exception.JsonException;
import io.apptik.json.schema.Schema;
import io.apptik.json.schema.SchemaV4;
import io.apptik.json.schema.fetch.SchemaFetcher;
import io.apptik.json.schema.fetch.SchemaFetcherConfig;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;

public class SchemaUriFetcher
implements SchemaFetcher {
    private SchemaFetcherConfig cfg;

    public URI resolveUri(URI targetUri, URI srcOrigUri, URI srcId) {
        if (targetUri.isAbsolute()) {
            return targetUri;
        }
        if (srcOrigUri == null || !srcOrigUri.isAbsolute()) {
            return targetUri;
        }
        return srcOrigUri.resolve(targetUri);
    }

    public URI convertUri(URI schemaUri) {
        if (this.cfg == null) {
            return schemaUri;
        }
        URI res = null;
        String scheme = schemaUri.getScheme();
        String authority = schemaUri.getAuthority();
        String path = schemaUri.getPath();
        String query = schemaUri.getQuery();
        if (this.cfg.uriSchemeReplacements.containsKey(scheme)) {
            scheme = this.cfg.uriSchemeReplacements.get(scheme);
        }
        if (this.cfg.uriAuthorityReplacements.containsKey(authority)) {
            authority = this.cfg.uriAuthorityReplacements.get(authority);
        }
        if (this.cfg.uriPathReplacements.containsKey(path)) {
            path = this.cfg.uriPathReplacements.get(path);
        }
        if (this.cfg.uriQueryReplacements.containsKey(query)) {
            query = this.cfg.uriQueryReplacements.get(query);
        }
        try {
            res = new URI(scheme, authority, path, query, schemaUri.getFragment());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return res;
    }

    public Schema fetch(URI targetUri) {
        return this.fetch(targetUri, null, null);
    }

    @Override
    public Schema fetch(URI targetUri, URI srcOrigUri, URI srcId) {
        Schema res = null;
        URI schemaUri = this.convertUri(this.resolveUri(targetUri, srcOrigUri, srcId));
        if (!schemaUri.isAbsolute()) {
            throw new RuntimeException("Json Schema Fetcher works only with absolute URIs");
        }
        try {
            String version;
            String fragment = schemaUri.getFragment();
            JsonObject schemaJson = JsonElement.readFrom((Reader)new InputStreamReader(schemaUri.toURL().openStream())).asJsonObject();
            if (fragment != null && !fragment.trim().isEmpty()) {
                String[] pointers;
                for (String pointer : pointers = fragment.split("/")) {
                    if (pointer == null || pointer.trim().isEmpty()) continue;
                    schemaJson = schemaJson.getJsonObject(pointer);
                }
            }
            res = (version = schemaJson.optString("$schema", "")).equals("http://json-schema.org/draft-04/schema#") ? (Schema)((Object)((Schema)((Object)((Schema)((Object)new SchemaV4().setSchemaFetcher(this))).setOrigSrc(schemaUri))).wrap(schemaJson)) : (Schema)((Object)((Schema)((Object)((Schema)((Object)new SchemaV4().setSchemaFetcher(this))).setOrigSrc(schemaUri))).wrap(schemaJson));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonException e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public SchemaFetcher withConfig(SchemaFetcherConfig cfg) {
        this.cfg = cfg;
        return this;
    }
}

