/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.schema.validation;

import io.apptik.json.JsonArray;
import io.apptik.json.JsonElement;
import io.apptik.json.schema.Schema;
import io.apptik.json.schema.SchemaList;
import io.apptik.json.schema.SchemaMap;
import io.apptik.json.schema.SchemaV4;
import io.apptik.json.schema.validation.CommonMatchers;
import io.apptik.json.schema.validation.SchemaValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public class SchemaV4Validator
extends SchemaValidator<SchemaV4> {
    ArrayList<Matcher<? super JsonElement>> allMatchers = new ArrayList();

    public SchemaV4Validator(SchemaV4 schema) {
        super(schema);
        this.putMatchers4Numeric();
        this.putMatchers4String();
        this.putMatchers4Array();
        this.putMatcher4Object();
        this.putMatchers4Common();
    }

    private void putMatchers4Numeric() {
        Double minimum;
        Double maximum;
        Double multipleOf = ((SchemaV4)this.schema).getMultipleOf();
        if (multipleOf != null && multipleOf > 0.0) {
            this.allMatchers.add(CommonMatchers.isMultipleOf(multipleOf));
        }
        if ((maximum = ((SchemaV4)this.schema).getMaximum()) != null) {
            if (((SchemaV4)this.schema).getExclusiveMaximum()) {
                this.allMatchers.add(CommonMatchers.isLessThan(maximum));
            } else {
                this.allMatchers.add(CommonMatchers.isLessOrEqualThan(maximum));
            }
        }
        if ((minimum = ((SchemaV4)this.schema).getMinimum()) != null) {
            if (((SchemaV4)this.schema).getExclusiveMinimum()) {
                this.allMatchers.add(CommonMatchers.isMoreThan(minimum));
            } else {
                this.allMatchers.add(CommonMatchers.isMoreOrEqualThan(minimum));
            }
        }
    }

    private void putMatchers4String() {
        String pattern;
        Integer minLength;
        Integer maxLength = ((SchemaV4)this.schema).getMaxLength();
        if (maxLength != null) {
            this.allMatchers.add(CommonMatchers.withCharsLessOrEqualTo(maxLength));
        }
        if ((minLength = ((SchemaV4)this.schema).getMinLength()) != null && minLength > 0) {
            this.allMatchers.add(CommonMatchers.withCharsMoreOrEqualTo(minLength));
        }
        if ((pattern = ((SchemaV4)this.schema).getPattern()) != null && !pattern.isEmpty()) {
            this.allMatchers.add(CommonMatchers.matchesPattern(pattern));
        }
    }

    private void putMatchers4Array() {
        Integer minItems;
        Integer maxItems;
        SchemaList items = ((SchemaV4)this.schema).getItems();
        if (items != null && !items.isEmpty()) {
            if (items.size() == 1) {
                this.allMatchers.add(CommonMatchers.areItemsValid(((Schema)((Object)items.get(0))).getDefaultValidator()));
            } else {
                if (!((SchemaV4)this.schema).getAdditionalItems()) {
                    this.allMatchers.add(CommonMatchers.doesItemCountMatches(items.size()));
                }
                for (int i = 0; i < items.size(); ++i) {
                    this.allMatchers.add(CommonMatchers.isItemValid(((Schema)((Object)items.get(i))).getDefaultValidator(), i));
                }
            }
        }
        if ((maxItems = ((SchemaV4)this.schema).getMaxItems()) != null) {
            this.allMatchers.add(CommonMatchers.maxItems(maxItems));
        }
        if ((minItems = ((SchemaV4)this.schema).getMinItems()) != null) {
            this.allMatchers.add(CommonMatchers.minItems(minItems));
        }
        if (((SchemaV4)this.schema).getUniqueItems()) {
            this.allMatchers.add(CommonMatchers.areItemsUnique());
        }
    }

    private void putMatcher4Object() {
        boolean additionalProperties;
        SchemaMap schemaMap;
        Object entry;
        SchemaMap propertiesSchemaMap;
        List<String> required;
        Integer minProperties;
        Integer maxProperties = ((SchemaV4)this.schema).getMaxProperties();
        if (maxProperties != null) {
            this.allMatchers.add(CommonMatchers.maxProperties(maxProperties));
        }
        if ((minProperties = ((SchemaV4)this.schema).getMinProperties()) != null && minProperties > 0) {
            this.allMatchers.add(CommonMatchers.minProperties(minProperties));
        }
        if ((required = ((SchemaV4)this.schema).getRequired()) != null && !required.isEmpty()) {
            for (String string : required) {
                this.allMatchers.add(CommonMatchers.isPropertyPresent(string));
            }
        }
        if ((propertiesSchemaMap = ((SchemaV4)this.schema).getProperties()) != null && propertiesSchemaMap.length() > 0) {
            Iterator iterator = propertiesSchemaMap.iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                this.allMatchers.add(CommonMatchers.isPropertyValid(((Schema)((Object)entry.getValue())).getDefaultValidator(), (String)entry.getKey()));
            }
        }
        if ((schemaMap = ((SchemaV4)this.schema).getPatternProperties()) != null && schemaMap.length() > 0) {
            entry = schemaMap.iterator();
            while (entry.hasNext()) {
                Map.Entry entry2 = (Map.Entry)entry.next();
                this.allMatchers.add(CommonMatchers.isPropertyPatternValid(((Schema)((Object)entry2.getValue())).getDefaultValidator(), (String)entry2.getKey()));
            }
        }
        if (!(additionalProperties = ((SchemaV4)this.schema).getAdditionalProperties())) {
            Set<String> proppertiesSet = propertiesSchemaMap == null || propertiesSchemaMap.getEntries() == null ? Collections.EMPTY_SET : propertiesSchemaMap.getEntries().keySet();
            Set<String> patternPropertiesSet = schemaMap == null || schemaMap.getEntries() == null ? Collections.EMPTY_SET : schemaMap.getEntries().keySet();
            this.allMatchers.add(CommonMatchers.isNoAdditionalProperties(proppertiesSet, patternPropertiesSet));
        }
    }

    private void putMatchers4Common() {
        JsonArray enums;
        List<String> schemaType = ((SchemaV4)this.schema).getType();
        if (schemaType != null && !schemaType.isEmpty()) {
            this.allMatchers.add(CommonMatchers.isOfType(schemaType));
        }
        if ((enums = ((SchemaV4)this.schema).getEnum()) != null) {
            this.allMatchers.add(CommonMatchers.isInEnums(enums));
        }
    }

    protected boolean doValidate(JsonElement el, StringBuilder sb) {
        if (this.allMatchers == null || this.allMatchers.isEmpty()) {
            System.out.println("SchemaV4Validator NO MATCHERS end: " + this.getTitle());
            return true;
        }
        Matcher matcher = Matchers.allOf(this.allMatchers);
        if (sb != null) {
            matcher.describeMismatch((Object)el, (Description)new StringDescription((Appendable)sb));
        }
        return matcher.matches((Object)el);
    }
}

