/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.schema;

import io.apptik.json.JsonArray;
import io.apptik.json.JsonElement;
import io.apptik.json.JsonObject;
import io.apptik.json.schema.Schema;
import io.apptik.json.schema.SchemaV4;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class SchemaJJv1
extends SchemaV4 {
    public SchemaJJv1() {
        this.setSchema("http://openthings.cc/schema/schema-jj-01");
    }

    @Override
    public Schema getEmptySchema(String path) {
        return ((Schema)((Object)new SchemaJJv1().setSchemaFetcher(this.schemaFetcher))).setOrigSrc(this.origSrc.resolve(path));
    }

    public Schema setSuperSchema(URI superSchema) {
        this.getJson().put("extends", (Object)this.getSchemaFetcher().fetch(superSchema, null, null));
        return this;
    }

    public <O extends SchemaJJv1> O setSuperSchemaRef(String superSchemaUri) {
        this.getJson().put("extends", (JsonElement)new JsonObject().put("$ref", (Object)superSchemaUri));
        return (O)((Object)this);
    }

    public <O extends SchemaJJv1> O setExtends(Schema superSchema) {
        this.getJson().put("extends", (Object)superSchema);
        return (O)((Object)this);
    }

    public Schema getExtends() {
        return (Schema)((Object)this.getEmptySchema("extends").wrap(this.getJson().optJsonObject("extends")));
    }

    public <O extends SchemaJJv1> O addEquivalent(String equivalent) {
        JsonArray equivArray = this.getJson().optJsonArray("equivalent");
        if (equivArray == null) {
            this.getJson().put("equivalent", (JsonElement)new JsonArray());
        }
        this.getJson().getJsonArray("equivalent").put((Object)equivalent);
        return (O)((Object)this);
    }

    public <O extends SchemaJJv1> O addEquivalentList(Collection<String> equivalents) {
        JsonArray equivArray = this.getJson().optJsonArray("equivalent");
        if (equivArray == null) {
            this.getJson().put("equivalent", equivalents);
        }
        return (O)((Object)this);
    }

    public ArrayList<String> getEquivalents() {
        JsonArray equivArray = this.getJson().optJsonArray("equivalent");
        if (equivArray == null) {
            return null;
        }
        return equivArray.toArrayList();
    }
}

