/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.schema.fetch;

import io.apptik.json.JsonElement;
import io.apptik.json.exception.JsonException;
import io.apptik.json.schema.Schema;
import io.apptik.json.schema.SchemaV4;
import io.apptik.json.schema.fetch.SchemaFetcher;
import io.apptik.json.schema.fetch.SchemaFetcherConfig;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;

public class SchemaResourceFetcher
implements SchemaFetcher {
    @Override
    public Schema fetch(URI targetUri, URI srcOrigUri, URI srcId) {
        SchemaV4 res = new SchemaV4();
        String resource = targetUri.getPath();
        URL url = this.getClass().getClassLoader().getResource(resource);
        System.out.println("Fetching res (simpple):" + resource);
        System.out.println("Fetching res (full):" + url);
        try {
            res.wrap(JsonElement.readFrom((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resource))).asJsonObject());
        }
        catch (JsonException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public SchemaFetcher withConfig(SchemaFetcherConfig cfg) {
        return null;
    }

    public Schema fetch(URI targetUri) {
        return this.fetch(targetUri, null, null);
    }
}

