/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.widget;

import android.support.test.espresso.UiController;
import android.support.test.espresso.ViewAction;
import android.support.test.espresso.matcher.ViewMatchers;
import android.view.View;
import io.apptik.widget.MultiSlider;
import org.hamcrest.Matcher;

public class SetThumbValueAction
implements ViewAction {
    private int value;
    private MultiSlider.Thumb thumb;
    private int thumbId = -1;

    public SetThumbValueAction(MultiSlider.Thumb thumb, int value) {
        this.value = value;
    }

    public SetThumbValueAction(int thumbId, int value) {
        this.value = value;
        this.thumbId = thumbId;
    }

    private String getThumbDesc() {
        if (this.thumbId < 0) {
            return this.thumb.getTag();
        }
        return "thumb Id: " + this.thumbId;
    }

    private MultiSlider.Thumb getThumb(MultiSlider ms) {
        if (this.thumbId < 0) {
            return this.thumb;
        }
        return ms.getThumb(this.thumbId);
    }

    public Matcher<View> getConstraints() {
        return ViewMatchers.isAssignableFrom(MultiSlider.class);
    }

    public String getDescription() {
        if (this.value == Integer.MAX_VALUE) {
            return String.format("Move forward thumb: %s", this.getThumbDesc());
        }
        if (this.value == Integer.MIN_VALUE) {
            return String.format("Move backward thumb: %s", this.getThumbDesc());
        }
        return String.format("Set value (%s) for thumb: %s", this.value, this.getThumbDesc());
    }

    public void perform(UiController uiController, View view) {
        if (this.value == Integer.MAX_VALUE) {
            this.value = this.getThumb((MultiSlider)view).getValue() + ((MultiSlider)view).getStep();
        } else if (this.value == Integer.MIN_VALUE) {
            this.value = this.getThumb((MultiSlider)view).getValue() - ((MultiSlider)view).getStep();
        }
        this.getThumb((MultiSlider)view).setValue(this.value);
    }
}

