/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import io.appulse.utils.BytesSliceBuilder;
import io.appulse.utils.BytesUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.NonNull;

abstract class BytesAbstract
implements Bytes {
    BytesAbstract() {
    }

    @Override
    public Bytes writeNB(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return this.writeNB(bytes, 0);
    }

    @Override
    public Bytes writeNB(@NonNull byte[] bytes, int offset) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return this.writeNB(bytes, offset, bytes.length);
    }

    @Override
    public Bytes writeNB(String value) {
        return this.writeNB(value, StandardCharsets.ISO_8859_1);
    }

    @Override
    public Bytes writeNB(@NonNull String value, @NonNull Charset charset) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        byte[] bytes = value.getBytes(charset);
        return this.writeNB(bytes);
    }

    @Override
    public Bytes write1B(short value) {
        return this.write1B((byte)value);
    }

    @Override
    public Bytes write1B(int value) {
        return this.write1B((byte)value);
    }

    @Override
    public Bytes write1B(long value) {
        return this.write1B((byte)value);
    }

    @Override
    public Bytes write1B(float value) {
        int intValue = Float.floatToIntBits(value);
        return this.write1B((byte)intValue);
    }

    @Override
    public Bytes write1B(double value) {
        long longValue = Double.doubleToLongBits(value);
        return this.write1B((byte)longValue);
    }

    @Override
    public Bytes write1B(char value) {
        return this.write1B((byte)value);
    }

    @Override
    public Bytes write2B(byte value) {
        return this.write2B((short)value);
    }

    @Override
    public Bytes write2B(int value) {
        return this.write2B((short)value);
    }

    @Override
    public Bytes write2B(long value) {
        return this.write2B((short)value);
    }

    @Override
    public Bytes write2B(float value) {
        int intValue = Float.floatToIntBits(value);
        return this.write2B((short)intValue);
    }

    @Override
    public Bytes write2B(double value) {
        long longValue = Double.doubleToLongBits(value);
        return this.write2B((short)longValue);
    }

    @Override
    public Bytes write2B(char value) {
        return this.write2B((short)value);
    }

    @Override
    public Bytes write4B(byte value) {
        return this.write4B((int)value);
    }

    @Override
    public Bytes write4B(short value) {
        return this.write4B((int)value);
    }

    @Override
    public Bytes write4B(long value) {
        return this.write4B((int)value);
    }

    @Override
    public Bytes write4B(float value) {
        int intValue = Float.floatToIntBits(value);
        return this.write4B(intValue);
    }

    @Override
    public Bytes write4B(double value) {
        long longValue = Double.doubleToLongBits(value);
        return this.write4B((int)longValue);
    }

    @Override
    public Bytes write4B(char value) {
        return this.write4B((int)value);
    }

    @Override
    public Bytes write8B(byte value) {
        return this.write8B((long)value);
    }

    @Override
    public Bytes write8B(short value) {
        return this.write8B((long)value);
    }

    @Override
    public Bytes write8B(int value) {
        return this.write8B((long)value);
    }

    @Override
    public Bytes write8B(float value) {
        int intValue = Float.floatToIntBits(value);
        return this.write8B((long)intValue);
    }

    @Override
    public Bytes write8B(double value) {
        long longValue = Double.doubleToLongBits(value);
        return this.write8B(longValue);
    }

    @Override
    public Bytes write8B(char value) {
        return this.write8B((long)value);
    }

    @Override
    public Bytes setNB(int index, @NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return this.setNB(index, bytes, 0, bytes.length);
    }

    @Override
    public Bytes setNB(int index, @NonNull byte[] bytes, int offset) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return this.setNB(index, bytes, offset, bytes.length);
    }

    @Override
    public Bytes setNB(int index, String value) {
        return this.setNB(index, value, StandardCharsets.ISO_8859_1);
    }

    @Override
    public Bytes setNB(int index, @NonNull String value, @NonNull Charset charset) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        byte[] bytes = value.getBytes(charset);
        return this.setNB(index, bytes);
    }

    @Override
    public Bytes set1B(int index, short value) {
        return this.set1B(index, (byte)value);
    }

    @Override
    public Bytes set1B(int index, int value) {
        return this.set1B(index, (byte)value);
    }

    @Override
    public Bytes set1B(int index, long value) {
        return this.set1B(index, (byte)value);
    }

    @Override
    public Bytes set1B(int index, float value) {
        int intValue = Float.floatToIntBits(value);
        return this.set1B(index, (byte)intValue);
    }

    @Override
    public Bytes set1B(int index, double value) {
        long longValue = Double.doubleToLongBits(value);
        return this.set1B(index, (byte)longValue);
    }

    @Override
    public Bytes set1B(int index, char value) {
        return this.set1B(index, (byte)value);
    }

    @Override
    public Bytes set2B(int index, byte value) {
        return this.set2B(index, (short)value);
    }

    @Override
    public Bytes set2B(int index, int value) {
        return this.set2B(index, (short)value);
    }

    @Override
    public Bytes set2B(int index, long value) {
        return this.set2B(index, (short)value);
    }

    @Override
    public Bytes set2B(int index, float value) {
        int intValue = Float.floatToIntBits(value);
        return this.set2B(index, (short)intValue);
    }

    @Override
    public Bytes set2B(int index, double value) {
        long longValue = Double.doubleToLongBits(value);
        return this.set2B(index, (short)longValue);
    }

    @Override
    public Bytes set2B(int index, char value) {
        return this.set2B(index, (short)value);
    }

    @Override
    public Bytes set4B(int index, byte value) {
        return this.set4B(index, (int)value);
    }

    @Override
    public Bytes set4B(int index, short value) {
        return this.set4B(index, (int)value);
    }

    @Override
    public Bytes set4B(int index, long value) {
        return this.set4B(index, (int)value);
    }

    @Override
    public Bytes set4B(int index, float value) {
        int intValue = Float.floatToIntBits(value);
        return this.set4B(index, intValue);
    }

    @Override
    public Bytes set4B(int index, double value) {
        long longValue = Double.doubleToLongBits(value);
        return this.set4B(index, (int)longValue);
    }

    @Override
    public Bytes set4B(int index, char value) {
        return this.set4B(index, (int)value);
    }

    @Override
    public Bytes set8B(int index, byte value) {
        return this.set8B(index, (long)value);
    }

    @Override
    public Bytes set8B(int index, short value) {
        return this.set8B(index, (long)value);
    }

    @Override
    public Bytes set8B(int index, int value) {
        return this.set8B(index, (long)value);
    }

    @Override
    public Bytes set8B(int index, float value) {
        int intValue = Float.floatToIntBits(value);
        return this.set8B(index, (long)intValue);
    }

    @Override
    public Bytes set8B(int index, double value) {
        long longValue = Double.doubleToLongBits(value);
        return this.set8B(index, longValue);
    }

    @Override
    public Bytes set8B(int index, char value) {
        return this.set8B(index, (long)value);
    }

    @Override
    public short readUnsignedByte() {
        byte value = this.readByte();
        return BytesUtils.asUnsignedByte(value);
    }

    @Override
    public int readUnsignedShort() {
        short value = this.readShort();
        return BytesUtils.asUnsignedShort(value);
    }

    @Override
    public long readUnsignedInt() {
        int value = this.readInt();
        return BytesUtils.asUnsignedInteger(value);
    }

    @Override
    public BigInteger readUnsignedLong() {
        long value = this.readLong();
        return BytesUtils.asUnsignedLong(value);
    }

    @Override
    public byte[] readBytes() {
        byte[] result = this.readBytes(this.readerIndex());
        this.readerIndex(this.capacity());
        return result;
    }

    @Override
    public byte[] readBytes(int length) {
        byte[] result = new byte[length];
        this.readBytes(result);
        return result;
    }

    @Override
    public Bytes readBytes(@NonNull byte[] destination) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        return this.readBytes(destination, 0, destination.length);
    }

    @Override
    public String readString() {
        return this.readString(StandardCharsets.ISO_8859_1);
    }

    @Override
    public String readString(int length) {
        return this.readString(length, StandardCharsets.ISO_8859_1);
    }

    @Override
    public String readString(Charset charset) {
        String result = this.getString(this.readerIndex(), charset);
        this.readerIndex(this.capacity());
        return result;
    }

    @Override
    public String readString(int length, Charset charset) {
        String result = this.getString(this.readerIndex(), length, charset);
        this.readerIndex(this.readerIndex() + length);
        return result;
    }

    @Override
    public short getUnsignedByte(int index) {
        byte value = this.getByte(index);
        return BytesUtils.asUnsignedByte(value);
    }

    @Override
    public int getUnsignedShort(int index) {
        short value = this.getShort(index);
        return BytesUtils.asUnsignedShort(value);
    }

    @Override
    public long getUnsignedInt(int index) {
        int value = this.getInt(index);
        return BytesUtils.asUnsignedInteger(value);
    }

    @Override
    public BigInteger getUnsignedLong(int index) {
        long value = this.getLong(index);
        return BytesUtils.asUnsignedLong(value);
    }

    @Override
    public byte[] getBytes(int index) {
        return this.getBytes(index, this.capacity() - index);
    }

    @Override
    public String getString(int index) {
        return this.getString(index, StandardCharsets.ISO_8859_1);
    }

    @Override
    public String getString(int index, Charset charset) {
        return this.getString(index, this.capacity() - index, charset);
    }

    @Override
    public String getString(int index, int length) {
        return this.getString(index, length, StandardCharsets.ISO_8859_1);
    }

    @Override
    public int readableBytes() {
        return this.writerIndex() - this.readerIndex();
    }

    @Override
    public boolean isReadable() {
        return this.readableBytes() > 0;
    }

    @Override
    public boolean isReadable(int size) {
        return this.readableBytes() >= size;
    }

    @Override
    public int writableBytes() {
        return this.capacity() - this.writerIndex();
    }

    @Override
    public boolean isWritable() {
        return this.writableBytes() > 0;
    }

    @Override
    public boolean isWritable(int size) {
        return this.writableBytes() >= size;
    }

    @Override
    public Bytes reset() {
        this.readerIndex(0);
        this.writerIndex(0);
        return this;
    }

    @Override
    public byte[] arrayCopy() {
        return Arrays.copyOfRange(this.array(), 0, this.writerIndex());
    }

    @Override
    public BytesSliceBuilder slice() {
        return new BytesSliceBuilder(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "capacity=" + this.capacity() + ',' + "readerIndex=" + this.readerIndex() + ',' + "writerIndex=" + this.writerIndex() + '}';
    }

    protected void checkWriteBounds(int index, int length) {
        if (index < this.readerIndex() || index + length > this.capacity()) {
            String msg = String.format("Writer index error. index(%d) < readerIndex(%d) || index(%d)+length(%d) > capacity(%d)", index, this.readerIndex(), index, length, this.capacity());
            throw new IndexOutOfBoundsException(msg);
        }
    }

    protected void checkReaderBounds(int index, int length) {
        if (index < 0 || index + length > this.writerIndex()) {
            String msg = String.format("Reader index error. index(%d) < 0 || index(%d)+length(%d) > writerIndex(%d)", index, index, length, this.writerIndex());
            throw new IndexOutOfBoundsException(msg);
        }
    }
}

