/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import io.appulse.utils.BytesSlice;
import java.util.Arrays;
import java.util.Locale;

public class BytesSliceBuilder {
    private final Bytes original;
    private int from;
    private int to;

    BytesSliceBuilder(Bytes bytes) {
        this.original = bytes;
        this.to = bytes.capacity();
    }

    public BytesSliceBuilder from(int index) {
        this.from = index;
        return this;
    }

    public BytesSliceBuilder to(int index) {
        this.to = index;
        return this;
    }

    public BytesSliceBuilder length(int length) {
        this.to = this.from + length;
        return this;
    }

    public byte[] toByteArray() {
        this.verify();
        return Arrays.copyOfRange(this.original.array(), this.from, this.to);
    }

    public Bytes toMutableBytes() {
        this.verify();
        return new BytesSlice(this.original, this.from, this.to);
    }

    public Bytes toReadOnlyBytes() {
        Bytes result = this.toMutableBytes();
        return Bytes.readOnly(result);
    }

    public Bytes toNewBytes() {
        byte[] bytes = this.toByteArray();
        return Bytes.wrap(bytes);
    }

    private void verify() {
        if (this.from < 0) {
            String msg = "'from' index must be greater or equal to 0";
            throw new IndexOutOfBoundsException("'from' index must be greater or equal to 0");
        }
        if (this.to > this.original.capacity()) {
            String msg = String.format(Locale.ENGLISH, "byte array has length %d, but 'to' index was set to %d", this.original.capacity(), this.to);
            throw new IndexOutOfBoundsException(msg);
        }
        if (this.from > this.to) {
            String msg = String.format(Locale.ENGLISH, "value 'from' (%d) must be less or equal 'to' (%d)", this.from, this.to);
            throw new IllegalArgumentException(msg);
        }
    }
}

