/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.exception.CantReadFromArrayException;
import io.appulse.utils.exception.CantWriteToArrayException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import lombok.NonNull;

public final class BytesUtils {
    public static void unsafeWriteByte(int value, byte[] bytes, int index) {
        bytes[index] = (byte)value;
    }

    public static void unsafeWriteShort(int value, byte[] bytes, int index) {
        bytes[index] = (byte)(value >> 8);
        bytes[index + 1] = (byte)value;
    }

    public static void unsafeWriteInteger(int value, byte[] bytes, int index) {
        bytes[index] = (byte)(value >> 24);
        bytes[index + 1] = (byte)(value >> 16);
        bytes[index + 2] = (byte)(value >> 8);
        bytes[index + 3] = (byte)value;
    }

    public static void unsafeWriteLong(long value, byte[] bytes, int index) {
        bytes[index] = (byte)(value >> 56);
        bytes[index + 1] = (byte)(value >> 48);
        bytes[index + 2] = (byte)(value >> 40);
        bytes[index + 3] = (byte)(value >> 32);
        bytes[index + 4] = (byte)(value >> 24);
        bytes[index + 5] = (byte)(value >> 16);
        bytes[index + 6] = (byte)(value >> 8);
        bytes[index + 7] = (byte)value;
    }

    public static void unsafeWriteFloat(float value, byte[] bytes, int index) {
        int intValue = Float.floatToIntBits(value);
        BytesUtils.unsafeWriteInteger(intValue, bytes, index);
    }

    public static void unsafeWriteDouble(double value, byte[] bytes, int index) {
        long longValue = Double.doubleToLongBits(value);
        BytesUtils.unsafeWriteLong(longValue, bytes, index);
    }

    public static void unsafeWriteCharacter(char value, byte[] bytes, int index) {
        bytes[index] = (byte)(value >> 8);
        bytes[index + 1] = (byte)value;
    }

    public static void unsafeWriteBytes(byte[] value, byte[] bytes, int index) {
        for (int i = 0; i < value.length; ++i) {
            bytes[index + i] = value[i];
        }
    }

    public static void writeByte(int value, @NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 1) {
            throw new CantWriteToArrayException(bytes, index, 1);
        }
        BytesUtils.unsafeWriteByte(value, bytes, index);
    }

    public static void writeShort(int value, @NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 2) {
            throw new CantWriteToArrayException(bytes, index, 2);
        }
        BytesUtils.unsafeWriteShort(value, bytes, index);
    }

    public static void writeInteger(int value, @NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 4) {
            throw new CantWriteToArrayException(bytes, index, 4);
        }
        BytesUtils.unsafeWriteInteger(value, bytes, index);
    }

    public static void writeLong(long value, @NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 8) {
            throw new CantWriteToArrayException(bytes, index, 8);
        }
        BytesUtils.unsafeWriteLong(value, bytes, index);
    }

    public static void writeFloat(float value, @NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 4) {
            throw new CantWriteToArrayException(bytes, index, 4);
        }
        BytesUtils.unsafeWriteFloat(value, bytes, index);
    }

    public static void writeDouble(double value, @NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 8) {
            throw new CantWriteToArrayException(bytes, index, 8);
        }
        BytesUtils.unsafeWriteDouble(value, bytes, index);
    }

    public static void writeCharacter(char value, @NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 2) {
            throw new CantWriteToArrayException(bytes, index, 2);
        }
        BytesUtils.unsafeWriteCharacter(value, bytes, index);
    }

    public static void writeBytes(byte[] value, @NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + value.length) {
            throw new CantWriteToArrayException(bytes, index, value.length);
        }
        BytesUtils.unsafeWriteBytes(value, bytes, index);
    }

    public static byte[] toBytes(byte value) {
        byte[] result = new byte[1];
        BytesUtils.writeByte(value, result, 0);
        return result;
    }

    public static byte[] toBytes(short value) {
        byte[] result = new byte[2];
        BytesUtils.writeShort(value, result, 0);
        return result;
    }

    public static byte[] toBytes(char value) {
        byte[] result = new byte[2];
        BytesUtils.writeCharacter(value, result, 0);
        return result;
    }

    public static byte[] toBytes(int value) {
        byte[] result = new byte[4];
        BytesUtils.writeInteger(value, result, 0);
        return result;
    }

    public static byte[] toBytes(long value) {
        byte[] result = new byte[8];
        BytesUtils.writeLong(value, result, 0);
        return result;
    }

    public static byte[] toBytes(float value) {
        byte[] result = new byte[4];
        BytesUtils.writeFloat(value, result, 0);
        return result;
    }

    public static byte[] toBytes(double value) {
        byte[] result = new byte[8];
        BytesUtils.writeDouble(value, result, 0);
        return result;
    }

    public static short unsafeReadUnsignedByte(byte[] bytes, int index) {
        return (short)(bytes[index] & 0xFF);
    }

    public static short unsafeReadShort(byte[] bytes, int index) {
        return (short)(bytes[index] << 8 | bytes[index + 1] & 0xFF);
    }

    public static int unsafeReadUnsignedShort(byte[] bytes, int index) {
        short value = BytesUtils.unsafeReadShort(bytes, index);
        return BytesUtils.asUnsignedShort(value);
    }

    public static char unsafeReadCharacter(byte[] bytes, int index) {
        return (char)(bytes[index] << 8 | bytes[index + 1] & 0xFF);
    }

    public static int unsafeReadInteger(byte[] bytes, int index) {
        return bytes[index] << 24 | (bytes[index + 1] & 0xFF) << 16 | (bytes[index + 2] & 0xFF) << 8 | bytes[index + 3] & 0xFF;
    }

    public static long unsafeReadUnsignedInteger(byte[] bytes, int index) {
        int value = BytesUtils.unsafeReadInteger(bytes, index);
        return BytesUtils.asUnsignedInteger(value);
    }

    public static long unsafeReadLong(byte[] bytes, int index) {
        return (long)bytes[index] << 56 | ((long)bytes[index + 1] & 0xFFL) << 48 | ((long)bytes[index + 2] & 0xFFL) << 40 | ((long)bytes[index + 3] & 0xFFL) << 32 | ((long)bytes[index + 4] & 0xFFL) << 24 | ((long)bytes[index + 5] & 0xFFL) << 16 | ((long)bytes[index + 6] & 0xFFL) << 8 | (long)bytes[index + 7] & 0xFFL;
    }

    public static float unsafeReadFloat(byte[] bytes, int index) {
        int value = BytesUtils.unsafeReadInteger(bytes, index);
        return Float.intBitsToFloat(value);
    }

    public static double unsafeReadDouble(byte[] bytes, int index) {
        long value = BytesUtils.unsafeReadLong(bytes, index);
        return Double.longBitsToDouble(value);
    }

    public static short readUnsignedByte(@NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 1) {
            throw new CantReadFromArrayException(bytes, index, 1);
        }
        return BytesUtils.unsafeReadUnsignedByte(bytes, index);
    }

    public static short readShort(@NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 2) {
            throw new CantReadFromArrayException(bytes, index, 2);
        }
        return BytesUtils.unsafeReadShort(bytes, index);
    }

    public static int readUnsignedShort(@NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 2) {
            throw new CantReadFromArrayException(bytes, index, 2);
        }
        return BytesUtils.unsafeReadUnsignedShort(bytes, index);
    }

    public static char readCharacter(@NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 2) {
            throw new CantReadFromArrayException(bytes, index, 2);
        }
        return BytesUtils.unsafeReadCharacter(bytes, index);
    }

    public static int readInteger(@NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 4) {
            throw new CantReadFromArrayException(bytes, index, 4);
        }
        return BytesUtils.unsafeReadInteger(bytes, index);
    }

    public static long readUnsignedInteger(@NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 4) {
            throw new CantReadFromArrayException(bytes, index, 4);
        }
        return BytesUtils.unsafeReadUnsignedInteger(bytes, index);
    }

    public static long readLong(@NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 8) {
            throw new CantReadFromArrayException(bytes, index, 8);
        }
        return BytesUtils.unsafeReadLong(bytes, index);
    }

    public static float readFloat(@NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 8) {
            throw new CantReadFromArrayException(bytes, index, 8);
        }
        return BytesUtils.unsafeReadFloat(bytes, index);
    }

    public static double readDouble(@NonNull byte[] bytes, int index) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length < index + 8) {
            throw new CantReadFromArrayException(bytes, index, 8);
        }
        return BytesUtils.unsafeReadDouble(bytes, index);
    }

    public static short asUnsignedByte(byte value) {
        return (short)(value & 0xFF);
    }

    public static short asUnsignedByte(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return BytesUtils.asShort(bytes);
    }

    public static short asShort(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] aligned = BytesUtils.align(bytes, 2);
        return BytesUtils.unsafeReadShort(aligned, 0);
    }

    public static int asUnsignedShort(short value) {
        return value & 0xFFFF;
    }

    public static int asUnsignedShort(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return BytesUtils.asShort(bytes) & 0xFFFF;
    }

    public static char asChar(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] aligned = BytesUtils.align(bytes, 2);
        return BytesUtils.unsafeReadCharacter(aligned, 0);
    }

    public static int asInteger(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] aligned = BytesUtils.align(bytes, 4);
        return BytesUtils.unsafeReadInteger(aligned, 0);
    }

    public static long asUnsignedInteger(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static long asUnsignedInteger(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return BytesUtils.asLong(bytes);
    }

    public static long asLong(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] aligned = BytesUtils.align(bytes, 8);
        return BytesUtils.unsafeReadLong(aligned, 0);
    }

    public static BigInteger asUnsignedLong(long value) {
        byte[] bytes = new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)};
        return BytesUtils.asUnsignedLong(bytes);
    }

    public static BigInteger asUnsignedLong(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] aligned = BytesUtils.align(bytes, 8);
        return new BigInteger(1, aligned);
    }

    public static float asFloat(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] aligned = BytesUtils.align(bytes, 4);
        return BytesUtils.unsafeReadFloat(aligned, 0);
    }

    public static double asDouble(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] aligned = BytesUtils.align(bytes, 8);
        return BytesUtils.unsafeReadDouble(aligned, 0);
    }

    public static byte[] concatenate(byte[] ... arrays) {
        if (arrays == null) {
            throw new NullPointerException("arrays is marked non-null but is null");
        }
        int size = Stream.of(arrays).mapToInt(it -> ((byte[])it).length).sum();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        Stream.of(arrays).forEach(buffer::put);
        return buffer.array();
    }

    public static byte[] align(@NonNull byte[] bytes, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (length <= 0 || bytes.length == length) {
            return bytes;
        }
        byte[] result = new byte[length];
        int srcPos = 0;
        int destPos = 0;
        if (bytes.length > length) {
            srcPos = bytes.length - length;
        } else if (bytes.length < length) {
            destPos = length - bytes.length;
        }
        System.arraycopy(bytes, srcPos, result, destPos, Math.min(bytes.length, length));
        return result;
    }

    private BytesUtils() {
        throw new UnsupportedOperationException();
    }
}

