/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;

public final class LimitedQueue<T>
extends LinkedList<T> {
    private static final long serialVersionUID = -5465432595539481983L;
    private final long capacity;

    @Override
    public boolean add(T value) {
        if ((long)this.size() >= this.capacity) {
            return false;
        }
        return super.add(value);
    }

    public boolean isFull() {
        return (long)this.size() < this.capacity;
    }

    @SuppressFBWarnings(justification="generated code")
    public LimitedQueue(long capacity) {
        this.capacity = capacity;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "LimitedQueue(capacity=" + this.getCapacity() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LimitedQueue)) {
            return false;
        }
        LimitedQueue other = (LimitedQueue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getCapacity() == other.getCapacity();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof LimitedQueue;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $capacity = this.getCapacity();
        result = result * 59 + (int)($capacity >>> 32 ^ $capacity);
        return result;
    }
}

