/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;

public final class RoundRobin<T> {
    private final AtomicInteger position = new AtomicInteger(0);
    private final T[] elements;
    private volatile int size;

    public RoundRobin(T ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        if (elements.length == 0) {
            throw new IllegalArgumentException("Elements array is empty");
        }
        this.elements = Arrays.copyOf(elements, elements.length);
        this.size = elements.length;
    }

    public RoundRobin(@NonNull Collection<T> collection) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Elements collection is empty");
        }
        this.size = collection.size();
        Class<?> elementType = collection.iterator().next().getClass();
        this.elements = (Object[])Array.newInstance(elementType, this.size);
        Iterator<T> iterator = collection.iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            this.elements[counter] = iterator.next();
            ++counter;
        }
    }

    public T getNext() {
        int index = this.getNextIndex();
        return this.elements[index];
    }

    private int getNextIndex() {
        int next;
        int current;
        do {
            if ((next = (current = this.position.get()) + 1) < this.size) continue;
            next = 0;
        } while (!this.position.compareAndSet(current, next));
        return current;
    }
}

