/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

public enum SizeUnit {
    BYTES{

        @Override
        public long toBytes(long value) {
            return value;
        }

        @Override
        public long toKilobytes(long value) {
            return value / 1024L;
        }

        @Override
        public long toMegabytes(long value) {
            return value / 0x100000L;
        }

        @Override
        public long toGigabytes(long value) {
            return value / 0x40000000L;
        }

        @Override
        public long toTerabytes(long value) {
            return value / 0x10000000000L;
        }

        @Override
        public long toPetabytes(long value) {
            return value / 0x4000000000000L;
        }

        @Override
        public long convert(long value, SizeUnit unit) {
            return unit.toBytes(value);
        }
    }
    ,
    KILOBYTES{

        @Override
        public long toBytes(long value) {
            return 2.scale(value, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long value) {
            return value;
        }

        @Override
        public long toMegabytes(long value) {
            return value / 1024L;
        }

        @Override
        public long toGigabytes(long value) {
            return value / 0x100000L;
        }

        @Override
        public long toTerabytes(long value) {
            return value / 0x40000000L;
        }

        @Override
        public long toPetabytes(long value) {
            return value / 0x10000000000L;
        }

        @Override
        public long convert(long value, SizeUnit unit) {
            return unit.toKilobytes(value);
        }
    }
    ,
    MEGABYTES{

        @Override
        public long toBytes(long value) {
            return 3.scale(value, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long value) {
            return 3.scale(value, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long value) {
            return value;
        }

        @Override
        public long toGigabytes(long value) {
            return value / 1024L;
        }

        @Override
        public long toTerabytes(long value) {
            return value / 0x100000L;
        }

        @Override
        public long toPetabytes(long value) {
            return value / 0x40000000L;
        }

        @Override
        public long convert(long value, SizeUnit unit) {
            return unit.toMegabytes(value);
        }
    }
    ,
    GIGABYTES{

        @Override
        public long toBytes(long value) {
            return 4.scale(value, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKilobytes(long value) {
            return 4.scale(value, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long value) {
            return 4.scale(value, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGigabytes(long value) {
            return value;
        }

        @Override
        public long toTerabytes(long value) {
            return value / 1024L;
        }

        @Override
        public long toPetabytes(long value) {
            return value / 0x100000L;
        }

        @Override
        public long convert(long value, SizeUnit unit) {
            return unit.toGigabytes(value);
        }
    }
    ,
    TERABYTES{

        @Override
        public long toBytes(long value) {
            return 5.scale(value, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toKilobytes(long value) {
            return 5.scale(value, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMegabytes(long value) {
            return 5.scale(value, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGigabytes(long value) {
            return 5.scale(value, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTerabytes(long value) {
            return value;
        }

        @Override
        public long toPetabytes(long value) {
            return value / 1024L;
        }

        @Override
        public long convert(long value, SizeUnit unit) {
            return unit.toTerabytes(value);
        }
    }
    ,
    PETABYTES{

        @Override
        public long toBytes(long value) {
            return 6.scale(value, 0x4000000000000L, 8191L);
        }

        @Override
        public long toKilobytes(long value) {
            return 6.scale(value, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toMegabytes(long value) {
            return 6.scale(value, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toGigabytes(long value) {
            return 6.scale(value, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toTerabytes(long value) {
            return 6.scale(value, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toPetabytes(long value) {
            return value;
        }

        @Override
        public long convert(long value, SizeUnit unit) {
            return unit.toPetabytes(value);
        }
    };

    static final long BYTE = 1L;
    static final long KILOBYTE = 1024L;
    static final long MEGABYTE = 0x100000L;
    static final long GIGABYTE = 0x40000000L;
    static final long TERABYTE = 0x10000000000L;
    static final long PETABYTE = 0x4000000000000L;
    static final long MAX = Long.MAX_VALUE;

    static long scale(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public long convert(long source, SizeUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public long toBytes(long value) {
        throw new AbstractMethodError();
    }

    public long toKilobytes(long value) {
        throw new AbstractMethodError();
    }

    public long toMegabytes(long value) {
        throw new AbstractMethodError();
    }

    public long toGigabytes(long value) {
        throw new AbstractMethodError();
    }

    public long toTerabytes(long value) {
        throw new AbstractMethodError();
    }

    public long toPetabytes(long value) {
        throw new AbstractMethodError();
    }
}

