/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads;

import io.appulse.utils.threads.CompletablePromiseContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.NonNull;

public class CompletablePromise<T>
extends CompletableFuture<T> {
    private Future<T> future;

    public CompletablePromise(@NonNull Future<T> future) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        this.future = future;
        CompletablePromiseContext.getInstance().schedule(this::tryToComplete);
    }

    private void tryToComplete() {
        if (this.future.isDone()) {
            try {
                this.complete(this.future.get());
            }
            catch (InterruptedException e) {
                this.completeExceptionally(e);
            }
            catch (ExecutionException e) {
                this.completeExceptionally(e.getCause());
            }
            return;
        }
        if (this.future.isCancelled()) {
            this.cancel(true);
            return;
        }
        CompletablePromiseContext.getInstance().schedule(this::tryToComplete);
    }
}

