/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads;

import io.appulse.utils.threads.CompletablePromise;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.NonNull;

public final class FutureUtils {
    public static <T> CompletableFuture<T> completedExceptionally(Throwable throwable) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static <T> CompletableFuture<T> firstCompletedWithoutException(CompletionStage<? extends T> ... futures) {
        if (futures == null) {
            throw new NullPointerException("futures is marked non-null but is null");
        }
        Stream<CompletionStage<? extends T>> stream = Stream.of(futures);
        return FutureUtils.firstCompletedWithoutException(stream);
    }

    public static <T> CompletableFuture<T> firstCompletedWithoutException(@NonNull List<? extends CompletionStage<? extends T>> futures) {
        if (futures == null) {
            throw new NullPointerException("futures is marked non-null but is null");
        }
        Stream stream = futures.stream();
        return FutureUtils.firstCompletedWithoutException(stream);
    }

    public static <T> CompletableFuture<T> toCompletableFuture(@NonNull Future<T> future) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        return new CompletablePromise<T>(future);
    }

    private static <T> CompletableFuture<T> firstCompletedWithoutException(Stream<? extends CompletionStage<? extends T>> stream) {
        CompletableFuture result = new CompletableFuture();
        Consumer<Object> complete = result::complete;
        CompletableFuture[] futures = (CompletableFuture[])stream.map(it -> it.thenAccept(complete)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).exceptionally(ex -> {
            result.completeExceptionally((Throwable)ex);
            return null;
        });
        return result;
    }

    private FutureUtils() {
        throw new UnsupportedOperationException();
    }
}

