/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth;

import io.archimedesfw.security.auth.Role;
import io.archimedesfw.security.auth.Subject;
import io.archimedesfw.security.auth.SubjectRepository;
import io.archimedesfw.security.auth.SubjectService;
import jakarta.inject.Singleton;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/archimedesfw/security/auth/DefaultSubjectService;", "Lio/archimedesfw/security/auth/SubjectService;", "subjectRepository", "Lio/archimedesfw/security/auth/SubjectRepository;", "(Lio/archimedesfw/security/auth/SubjectRepository;)V", "create", "", "principal", "Ljava/security/Principal;", "roles", "", "Lio/archimedesfw/security/auth/Role;", "attributes", "", "", "", "find", "Lio/archimedesfw/security/auth/Subject;", "archimedes-security-auth-micronaut"})
public final class DefaultSubjectService
implements SubjectService {
    @NotNull
    private final SubjectRepository subjectRepository;

    public DefaultSubjectService(@NotNull SubjectRepository subjectRepository) {
        Intrinsics.checkNotNullParameter((Object)subjectRepository, (String)"subjectRepository");
        this.subjectRepository = subjectRepository;
    }

    @Override
    public int create(@NotNull Principal principal, @NotNull Set<Role> roles, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Subject subject = new Subject(-1, principal, roles, attributes);
        Subject savedSubject = this.subjectRepository.save(subject);
        return savedSubject.getId();
    }

    @Override
    @Nullable
    public Subject find(@NotNull Principal principal) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        String string = principal.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"principal.name");
        return this.subjectRepository.findByPrincipal(string);
    }

    @Override
    public boolean exists(@NotNull Principal principal) {
        return SubjectService.DefaultImpls.exists(this, principal);
    }
}

