/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.micronaut;

import io.archimedesfw.security.auth.Role;
import io.archimedesfw.security.auth.Subject;
import io.archimedesfw.security.auth.UsernamePrincipal;
import io.archimedesfw.security.auth.password.PasswordCredential;
import io.archimedesfw.security.auth.password.UsernamePasswordAuthenticator;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionStatus;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Scheduler;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/archimedesfw/security/auth/micronaut/DefaultAuthenticationProvider;", "Lio/micronaut/security/authentication/AuthenticationProvider;", "usernamePasswordAuthenticator", "Lio/archimedesfw/security/auth/password/UsernamePasswordAuthenticator;", "tx", "Lio/micronaut/transaction/SynchronousTransactionManager;", "Ljava/sql/Connection;", "ioScheduler", "Lreactor/core/scheduler/Scheduler;", "(Lio/archimedesfw/security/auth/password/UsernamePasswordAuthenticator;Lio/micronaut/transaction/SynchronousTransactionManager;Lreactor/core/scheduler/Scheduler;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "authenticate", "Lorg/reactivestreams/Publisher;", "Lio/micronaut/security/authentication/AuthenticationResponse;", "httpRequest", "Lio/micronaut/http/HttpRequest;", "authenticationRequest", "Lio/micronaut/security/authentication/AuthenticationRequest;", "archimedes-security-auth-micronaut"})
public final class DefaultAuthenticationProvider
implements AuthenticationProvider {
    @NotNull
    private final UsernamePasswordAuthenticator usernamePasswordAuthenticator;
    @NotNull
    private final SynchronousTransactionManager<Connection> tx;
    @NotNull
    private final Scheduler ioScheduler;
    private final Logger log;

    public DefaultAuthenticationProvider(@NotNull UsernamePasswordAuthenticator usernamePasswordAuthenticator, @NotNull SynchronousTransactionManager<Connection> tx, @Named(value="io") @NotNull Scheduler ioScheduler) {
        Intrinsics.checkNotNullParameter((Object)usernamePasswordAuthenticator, (String)"usernamePasswordAuthenticator");
        Intrinsics.checkNotNullParameter(tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)ioScheduler, (String)"ioScheduler");
        this.usernamePasswordAuthenticator = usernamePasswordAuthenticator;
        this.tx = tx;
        this.ioScheduler = ioScheduler;
        this.log = LoggerFactory.getLogger(DefaultAuthenticationProvider.class);
    }

    @NotNull
    public Publisher<AuthenticationResponse> authenticate(@Nullable HttpRequest<?> httpRequest, @NotNull AuthenticationRequest<?, ?> authenticationRequest) {
        Intrinsics.checkNotNullParameter(authenticationRequest, (String)"authenticationRequest");
        Mono mono = Mono.create(arg_0 -> DefaultAuthenticationProvider.authenticate$lambda$3(this, authenticationRequest, arg_0)).subscribeOn(this.ioScheduler);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"create<AuthenticationRes\u2026.subscribeOn(ioScheduler)");
        return (Publisher)mono;
    }

    private static final Subject authenticate$lambda$3$lambda$0(DefaultAuthenticationProvider this$0, AuthenticationRequest $authenticationRequest, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authenticationRequest, (String)"$authenticationRequest");
        return this$0.usernamePasswordAuthenticator.authenticate(new UsernamePrincipal($authenticationRequest.getIdentity().toString()), new PasswordCredential($authenticationRequest.getSecret().toString()));
    }

    private static final Optional authenticate$lambda$3$lambda$2(Authentication $authentication) {
        return Optional.of($authentication);
    }

    /*
     * WARNING - void declaration
     */
    private static final void authenticate$lambda$3(DefaultAuthenticationProvider this$0, AuthenticationRequest $authenticationRequest, MonoSink emitter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authenticationRequest, (String)"$authenticationRequest");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Subject subject = (Subject)this$0.tx.executeRead(arg_0 -> DefaultAuthenticationProvider.authenticate$lambda$3$lambda$0(this$0, $authenticationRequest, arg_0));
            Iterable iterable = subject.getRoles();
            String string = subject.getPrincipal().getName();
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Role role = (Role)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            Authentication authentication = Authentication.build((String)string, (Collection)((List)destination$iv$iv), subject.getAttributes());
            emitter.success(() -> DefaultAuthenticationProvider.authenticate$lambda$3$lambda$2(authentication));
        }
        catch (AuthenticationException ex) {
            emitter.error((Throwable)ex);
        }
        catch (Throwable th) {
            this$0.log.error("Cannot authenticate identity: " + $authenticationRequest.getIdentity(), th);
            emitter.error((Throwable)AuthenticationResponse.exception());
        }
    }
}

