/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.micronaut;

import io.archimedesfw.security.auth.Role;
import io.archimedesfw.security.auth.Subject;
import io.archimedesfw.security.auth.UsernamePrincipal;
import io.archimedesfw.security.auth.token.refresh.RefreshTokenAuthenticator;
import io.archimedesfw.security.auth.token.refresh.RefreshTokenCredential;
import io.archimedesfw.security.auth.token.refresh.RefreshTokenService;
import io.micronaut.runtime.event.annotation.EventListener;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.errors.ErrorCode;
import io.micronaut.security.errors.IssuingAnAccessTokenErrorCode;
import io.micronaut.security.errors.OauthErrorResponseException;
import io.micronaut.security.token.event.RefreshTokenGeneratedEvent;
import io.micronaut.security.token.refresh.RefreshTokenPersistence;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionStatus;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.security.Principal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Scheduler;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/archimedesfw/security/auth/micronaut/DefaultRefreshTokenPersistence;", "Lio/micronaut/security/token/refresh/RefreshTokenPersistence;", "refreshTokenService", "Lio/archimedesfw/security/auth/token/refresh/RefreshTokenService;", "refreshTokenAuthenticator", "Lio/archimedesfw/security/auth/token/refresh/RefreshTokenAuthenticator;", "tx", "Lio/micronaut/transaction/SynchronousTransactionManager;", "Ljava/sql/Connection;", "ioScheduler", "Lreactor/core/scheduler/Scheduler;", "(Lio/archimedesfw/security/auth/token/refresh/RefreshTokenService;Lio/archimedesfw/security/auth/token/refresh/RefreshTokenAuthenticator;Lio/micronaut/transaction/SynchronousTransactionManager;Lreactor/core/scheduler/Scheduler;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAuthentication", "Lorg/reactivestreams/Publisher;", "Lio/micronaut/security/authentication/Authentication;", "refreshToken", "", "persistToken", "", "event", "Lio/micronaut/security/token/event/RefreshTokenGeneratedEvent;", "archimedes-security-auth-micronaut"})
public class DefaultRefreshTokenPersistence
implements RefreshTokenPersistence {
    @NotNull
    private final RefreshTokenService refreshTokenService;
    @NotNull
    private final RefreshTokenAuthenticator refreshTokenAuthenticator;
    @NotNull
    private final SynchronousTransactionManager<Connection> tx;
    @NotNull
    private final Scheduler ioScheduler;
    private final Logger log;

    public DefaultRefreshTokenPersistence(@NotNull RefreshTokenService refreshTokenService, @NotNull RefreshTokenAuthenticator refreshTokenAuthenticator, @NotNull SynchronousTransactionManager<Connection> tx, @Named(value="io") @NotNull Scheduler ioScheduler) {
        Intrinsics.checkNotNullParameter((Object)refreshTokenService, (String)"refreshTokenService");
        Intrinsics.checkNotNullParameter((Object)refreshTokenAuthenticator, (String)"refreshTokenAuthenticator");
        Intrinsics.checkNotNullParameter(tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)ioScheduler, (String)"ioScheduler");
        this.refreshTokenService = refreshTokenService;
        this.refreshTokenAuthenticator = refreshTokenAuthenticator;
        this.tx = tx;
        this.ioScheduler = ioScheduler;
        this.log = LoggerFactory.getLogger(DefaultRefreshTokenPersistence.class);
    }

    @EventListener
    public void persistToken(@NotNull RefreshTokenGeneratedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.tx.executeWrite(arg_0 -> DefaultRefreshTokenPersistence.persistToken$lambda$0(this, event, arg_0));
    }

    @NotNull
    public Publisher<Authentication> getAuthentication(@NotNull String refreshToken) {
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Mono mono = Mono.create(arg_0 -> DefaultRefreshTokenPersistence.getAuthentication$lambda$3(this, refreshToken, arg_0)).subscribeOn(this.ioScheduler);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"create { emitter ->\n    \u2026.subscribeOn(ioScheduler)");
        return (Publisher)mono;
    }

    private static final Unit persistToken$lambda$0(DefaultRefreshTokenPersistence this$0, RefreshTokenGeneratedEvent $event, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        RefreshTokenService refreshTokenService = this$0.refreshTokenService;
        String string = $event.getAuthentication().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.authentication.name");
        Principal principal = new UsernamePrincipal(string);
        String string2 = $event.getRefreshToken();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.refreshToken");
        refreshTokenService.reset(principal, new RefreshTokenCredential(string2));
        return Unit.INSTANCE;
    }

    private static final Subject getAuthentication$lambda$3$lambda$1(DefaultRefreshTokenPersistence this$0, String $refreshToken, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$refreshToken, (String)"$refreshToken");
        return this$0.refreshTokenAuthenticator.authenticate(new RefreshTokenCredential($refreshToken));
    }

    /*
     * WARNING - void declaration
     */
    private static final void getAuthentication$lambda$3(DefaultRefreshTokenPersistence this$0, String $refreshToken, MonoSink emitter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$refreshToken, (String)"$refreshToken");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Subject subject = (Subject)this$0.tx.executeRead(arg_0 -> DefaultRefreshTokenPersistence.getAuthentication$lambda$3$lambda$1(this$0, $refreshToken, arg_0));
            Iterable iterable = subject.getRoles();
            String string = subject.getPrincipal().getName();
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Role role = (Role)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            Authentication authentication = Authentication.build((String)string, (Collection)((List)destination$iv$iv), subject.getAttributes());
            emitter.success((Object)authentication);
        }
        catch (OauthErrorResponseException ex) {
            emitter.error((Throwable)ex);
        }
        catch (Throwable th) {
            this$0.log.error("Cannot authenticate with refresh token", th);
            emitter.error((Throwable)new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_GRANT));
        }
    }
}

