/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.micronaut;

import io.archimedesfw.security.auth.Role;
import io.archimedesfw.security.auth.Subject;
import io.archimedesfw.security.auth.SubjectService;
import io.archimedesfw.security.auth.token.oauth2.PrincipalExtractor;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdTokenResponse;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionStatus;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.security.Principal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Named(value="google")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0011\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/archimedesfw/security/auth/micronaut/GoogleOpenIdAuthenticationMapper;", "Lio/micronaut/security/oauth2/endpoint/token/response/OpenIdAuthenticationMapper;", "principalExtractor", "Lio/archimedesfw/security/auth/token/oauth2/PrincipalExtractor;", "subjectService", "Lio/archimedesfw/security/auth/SubjectService;", "tx", "Lio/micronaut/transaction/SynchronousTransactionManager;", "Ljava/sql/Connection;", "(Lio/archimedesfw/security/auth/token/oauth2/PrincipalExtractor;Lio/archimedesfw/security/auth/SubjectService;Lio/micronaut/transaction/SynchronousTransactionManager;)V", "createAuthenticationResponse", "Lio/micronaut/security/authentication/AuthenticationResponse;", "providerName", "", "tokenResponse", "Lio/micronaut/security/oauth2/endpoint/token/response/OpenIdTokenResponse;", "openIdClaims", "Lio/micronaut/security/oauth2/endpoint/token/response/OpenIdClaims;", "state", "Lio/micronaut/security/oauth2/endpoint/authorization/state/State;", "Companion", "archimedes-security-auth-micronaut"})
public class GoogleOpenIdAuthenticationMapper
implements OpenIdAuthenticationMapper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PrincipalExtractor principalExtractor;
    @NotNull
    private final SubjectService subjectService;
    @NotNull
    private final SynchronousTransactionManager<Connection> tx;
    @Deprecated
    @NotNull
    private static final String SUBJECT_TOKEN_KEY = "sub";

    public GoogleOpenIdAuthenticationMapper(@NotNull PrincipalExtractor principalExtractor, @NotNull SubjectService subjectService, @NotNull SynchronousTransactionManager<Connection> tx) {
        Intrinsics.checkNotNullParameter((Object)principalExtractor, (String)"principalExtractor");
        Intrinsics.checkNotNullParameter((Object)subjectService, (String)"subjectService");
        Intrinsics.checkNotNullParameter(tx, (String)"tx");
        this.principalExtractor = principalExtractor;
        this.subjectService = subjectService;
        this.tx = tx;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AuthenticationResponse createAuthenticationResponse(@NotNull String providerName, @NotNull OpenIdTokenResponse tokenResponse, @NotNull OpenIdClaims openIdClaims, @Nullable State state) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter((Object)tokenResponse, (String)"tokenResponse");
        Intrinsics.checkNotNullParameter((Object)openIdClaims, (String)"openIdClaims");
        Principal principal = this.principalExtractor.extractPrincipal(openIdClaims);
        if (principal == null) {
            AuthenticationResponse authenticationResponse = AuthenticationResponse.failure((String)("Cannot extract principal from " + providerName + " token"));
            Intrinsics.checkNotNullExpressionValue((Object)authenticationResponse, (String)"failure(\"Cannot extract \u2026rom $providerName token\")");
            return authenticationResponse;
        }
        Principal principal2 = principal;
        Subject subject = (Subject)this.tx.executeRead(arg_0 -> GoogleOpenIdAuthenticationMapper.createAuthenticationResponse$lambda$0(this, principal2, arg_0));
        if (subject == null) {
            AuthenticationResponse authenticationResponse = AuthenticationResponse.failure((String)("Cannot authenticate principal " + principal2.getName()));
            Intrinsics.checkNotNullExpressionValue((Object)authenticationResponse, (String)"failure(\"Cannot authenti\u2026cipal ${principal.name}\")");
            return authenticationResponse;
        }
        Subject subject2 = subject;
        Object object = subject2.getAttributes().get(SUBJECT_TOKEN_KEY);
        if (object == null || (object = object.toString()) == null) {
            object = String.valueOf(subject2.getId());
        }
        Object sub = object;
        Iterable iterable = subject2.getRoles();
        Object object2 = sub;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        AuthenticationResponse authenticationResponse = AuthenticationResponse.success((String)object2, (Collection)((List)destination$iv$iv), subject2.getAttributes());
        Intrinsics.checkNotNullExpressionValue((Object)authenticationResponse, (String)"success(\n            sub\u2026ject.attributes\n        )");
        return authenticationResponse;
    }

    private static final Subject createAuthenticationResponse$lambda$0(GoogleOpenIdAuthenticationMapper this$0, Principal $principal, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$principal, (String)"$principal");
        return this$0.subjectService.find($principal);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/archimedesfw/security/auth/micronaut/GoogleOpenIdAuthenticationMapper$Companion;", "", "()V", "SUBJECT_TOKEN_KEY", "", "archimedes-security-auth-micronaut"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

