/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.password;

import io.archimedesfw.security.auth.Subject;
import io.archimedesfw.security.auth.SubjectRepository;
import io.archimedesfw.security.auth.password.PasswordCredential;
import io.archimedesfw.security.auth.password.PasswordEncoder;
import io.archimedesfw.security.auth.password.PasswordRepository;
import io.archimedesfw.security.auth.password.PasswordService;
import jakarta.inject.Singleton;
import java.security.Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/archimedesfw/security/auth/password/DefaultPasswordService;", "Lio/archimedesfw/security/auth/password/PasswordService;", "subjectRepository", "Lio/archimedesfw/security/auth/SubjectRepository;", "passwordEncoder", "Lio/archimedesfw/security/auth/password/PasswordEncoder;", "passwordRepository", "Lio/archimedesfw/security/auth/password/PasswordRepository;", "(Lio/archimedesfw/security/auth/SubjectRepository;Lio/archimedesfw/security/auth/password/PasswordEncoder;Lio/archimedesfw/security/auth/password/PasswordRepository;)V", "encode", "Lio/archimedesfw/security/auth/password/PasswordCredential;", "rawCredential", "reset", "", "principal", "Ljava/security/Principal;", "newPassword", "archimedes-security-auth-micronaut"})
public final class DefaultPasswordService
implements PasswordService {
    @NotNull
    private final SubjectRepository subjectRepository;
    @NotNull
    private final PasswordEncoder passwordEncoder;
    @NotNull
    private final PasswordRepository passwordRepository;

    public DefaultPasswordService(@NotNull SubjectRepository subjectRepository, @NotNull PasswordEncoder passwordEncoder, @NotNull PasswordRepository passwordRepository) {
        Intrinsics.checkNotNullParameter((Object)subjectRepository, (String)"subjectRepository");
        Intrinsics.checkNotNullParameter((Object)passwordEncoder, (String)"passwordEncoder");
        Intrinsics.checkNotNullParameter((Object)passwordRepository, (String)"passwordRepository");
        this.subjectRepository = subjectRepository;
        this.passwordEncoder = passwordEncoder;
        this.passwordRepository = passwordRepository;
    }

    @Override
    public void reset(@NotNull Principal principal, @NotNull PasswordCredential newPassword) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        String string = principal.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"principal.name");
        Subject subject = this.subjectRepository.findByPrincipal(string);
        if (subject == null) {
            return;
        }
        Subject subject2 = subject;
        PasswordCredential encodedCredential = this.encode(newPassword);
        this.passwordRepository.save(subject2.getId(), encodedCredential);
    }

    private final PasswordCredential encode(PasswordCredential rawCredential) {
        return new PasswordCredential(this.passwordEncoder.encode(rawCredential.getSecret()));
    }
}

