/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.password;

import io.archimedesfw.security.auth.Subject;
import io.archimedesfw.security.auth.SubjectRepository;
import io.archimedesfw.security.auth.password.PasswordCredential;
import io.archimedesfw.security.auth.password.PasswordEncoder;
import io.archimedesfw.security.auth.password.PasswordRepository;
import io.archimedesfw.security.auth.password.UsernamePasswordAuthenticator;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationFailureReason;
import io.micronaut.security.authentication.AuthenticationResponse;
import jakarta.inject.Singleton;
import java.security.Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/archimedesfw/security/auth/password/DefaultUsernamePasswordAuthenticator;", "Lio/archimedesfw/security/auth/password/UsernamePasswordAuthenticator;", "subjectRepository", "Lio/archimedesfw/security/auth/SubjectRepository;", "passwordRepository", "Lio/archimedesfw/security/auth/password/PasswordRepository;", "passwordEncoder", "Lio/archimedesfw/security/auth/password/PasswordEncoder;", "(Lio/archimedesfw/security/auth/SubjectRepository;Lio/archimedesfw/security/auth/password/PasswordRepository;Lio/archimedesfw/security/auth/password/PasswordEncoder;)V", "authenticate", "Lio/archimedesfw/security/auth/Subject;", "principal", "Ljava/security/Principal;", "password", "Lio/archimedesfw/security/auth/password/PasswordCredential;", "archimedes-security-auth-micronaut"})
public final class DefaultUsernamePasswordAuthenticator
implements UsernamePasswordAuthenticator {
    @NotNull
    private final SubjectRepository subjectRepository;
    @NotNull
    private final PasswordRepository passwordRepository;
    @NotNull
    private final PasswordEncoder passwordEncoder;

    public DefaultUsernamePasswordAuthenticator(@NotNull SubjectRepository subjectRepository, @NotNull PasswordRepository passwordRepository, @NotNull PasswordEncoder passwordEncoder) {
        Intrinsics.checkNotNullParameter((Object)subjectRepository, (String)"subjectRepository");
        Intrinsics.checkNotNullParameter((Object)passwordRepository, (String)"passwordRepository");
        Intrinsics.checkNotNullParameter((Object)passwordEncoder, (String)"passwordEncoder");
        this.subjectRepository = subjectRepository;
        this.passwordRepository = passwordRepository;
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    @NotNull
    public Subject authenticate(@NotNull Principal principal, @NotNull PasswordCredential password) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String string = principal.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"principal.name");
        Subject subject = this.subjectRepository.findByPrincipal(string);
        if (subject == null) {
            throw new AuthenticationException((AuthenticationResponse)new AuthenticationFailed(AuthenticationFailureReason.USER_NOT_FOUND));
        }
        Subject subject2 = subject;
        PasswordCredential passwordCredential = this.passwordRepository.findBySubjectId(subject2.getId());
        if (passwordCredential == null) {
            throw new AuthenticationException((AuthenticationResponse)new AuthenticationFailed(AuthenticationFailureReason.CREDENTIALS_DO_NOT_MATCH));
        }
        PasswordCredential passwordCredential2 = passwordCredential;
        if (!this.passwordEncoder.matches(password.getSecret(), passwordCredential2.getSecret())) {
            throw new AuthenticationException((AuthenticationResponse)new AuthenticationFailed(AuthenticationFailureReason.CREDENTIALS_DO_NOT_MATCH));
        }
        return subject2;
    }
}

