/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.password;

import io.archimedesfw.security.auth.password.PasswordEncoder;
import jakarta.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/archimedesfw/security/auth/password/SpringPasswordEncoder;", "Lio/archimedesfw/security/auth/password/PasswordEncoder;", "()V", "delegate", "Lorg/springframework/security/crypto/bcrypt/BCryptPasswordEncoder;", "encode", "", "rawPassword", "matches", "", "encodedPassword", "archimedes-security-auth-micronaut"})
public final class SpringPasswordEncoder
implements PasswordEncoder {
    @NotNull
    private final BCryptPasswordEncoder delegate = new BCryptPasswordEncoder();

    @Override
    @NotNull
    public String encode(@NotNull String rawPassword) {
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        String string = this.delegate.encode((CharSequence)rawPassword);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delegate.encode(rawPassword)");
        return string;
    }

    @Override
    public boolean matches(@NotNull String rawPassword, @NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        return this.delegate.matches((CharSequence)rawPassword, encodedPassword);
    }
}

