/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.password.persistence.jdbc;

import io.archimedesfw.security.auth.password.PasswordCredential;
import io.archimedesfw.security.auth.password.PasswordRepository;
import io.micronaut.data.jdbc.runtime.JdbcOperations;
import jakarta.inject.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/archimedesfw/security/auth/password/persistence/jdbc/PasswordRepositoryImpl;", "Lio/archimedesfw/security/auth/password/PasswordRepository;", "jdbcOperations", "Lio/micronaut/data/jdbc/runtime/JdbcOperations;", "(Lio/micronaut/data/jdbc/runtime/JdbcOperations;)V", "deleteBySubjectId", "", "findBySubjectId", "insert", "select", "table", "", "subjectId", "", "extractData", "", "Lio/archimedesfw/security/auth/password/PasswordCredential;", "rs", "Ljava/sql/ResultSet;", "save", "password", "archimedes-security-auth-micronaut"})
public final class PasswordRepositoryImpl
implements PasswordRepository {
    @NotNull
    private final JdbcOperations jdbcOperations;
    @NotNull
    private final String table;
    @NotNull
    private final String insert;
    @NotNull
    private final String deleteBySubjectId;
    @NotNull
    private final String select;
    @NotNull
    private final String findBySubjectId;

    public PasswordRepositoryImpl(@NotNull JdbcOperations jdbcOperations) {
        Intrinsics.checkNotNullParameter((Object)jdbcOperations, (String)"jdbcOperations");
        this.jdbcOperations = jdbcOperations;
        this.table = "archimedes_security_password";
        this.insert = "INSERT INTO " + this.table + "(subject_id, secret) VALUES (?, ?)";
        this.deleteBySubjectId = "DELETE FROM " + this.table + " WHERE subject_id = ?";
        this.select = "SELECT secret FROM " + this.table;
        this.findBySubjectId = this.select + " WHERE subject_id = ?";
    }

    @Override
    @NotNull
    public PasswordCredential save(int subjectId, @NotNull PasswordCredential password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.deleteBySubjectId(subjectId);
        Object object = this.jdbcOperations.prepareStatement(this.insert, arg_0 -> PasswordRepositoryImpl.save$lambda$0(subjectId, password, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026       password\n        }");
        return (PasswordCredential)object;
    }

    public final void deleteBySubjectId(int subjectId) {
        this.jdbcOperations.prepareStatement(this.deleteBySubjectId, arg_0 -> PasswordRepositoryImpl.deleteBySubjectId$lambda$1(subjectId, arg_0));
    }

    @Override
    @Nullable
    public PasswordCredential findBySubjectId(int subjectId) {
        Object object = this.jdbcOperations.prepareStatement(this.findBySubjectId, arg_0 -> PasswordRepositoryImpl.findBySubjectId$lambda$2(subjectId, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026extractData(rs)\n        }");
        return (PasswordCredential)CollectionsKt.singleOrNull((List)((List)object));
    }

    private final List<PasswordCredential> extractData(ResultSet rs) {
        List passwords = new ArrayList();
        while (rs.next()) {
            String string = rs.getString(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rs.getString(1)");
            passwords.add(new PasswordCredential(string));
        }
        return passwords;
    }

    private static final PasswordCredential save$lambda$0(int $subjectId, PasswordCredential $password, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)$password, (String)"$password");
        it.setInt(1, $subjectId);
        it.setString(2, $password.getSecret());
        it.executeUpdate();
        return $password;
    }

    private static final Integer deleteBySubjectId$lambda$1(int $subjectId, PreparedStatement it) {
        it.setInt(1, $subjectId);
        return it.executeUpdate();
    }

    private static final List findBySubjectId$lambda$2(int $subjectId, PasswordRepositoryImpl this$0, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setInt(1, $subjectId);
        ResultSet rs = it.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return this$0.extractData(rs);
    }
}

