/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.persistence.jdbc;

import io.archimedesfw.security.auth.Role;
import io.archimedesfw.security.auth.RoleRepository;
import io.micronaut.data.jdbc.runtime.JdbcOperations;
import jakarta.inject.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/archimedesfw/security/auth/persistence/jdbc/RoleRepositoryImpl;", "Lio/archimedesfw/security/auth/RoleRepository;", "jdbcOperations", "Lio/micronaut/data/jdbc/runtime/JdbcOperations;", "(Lio/micronaut/data/jdbc/runtime/JdbcOperations;)V", "findAll", "", "findByRole", "insert", "select", "table", "extractData", "", "Lio/archimedesfw/security/auth/Role;", "rs", "Ljava/sql/ResultSet;", "role", "findByRoleIn", "roles", "", "save", "archimedes-security-auth-micronaut"})
public final class RoleRepositoryImpl
implements RoleRepository {
    @NotNull
    private final JdbcOperations jdbcOperations;
    @NotNull
    private final String table;
    @NotNull
    private final String insert;
    @NotNull
    private final String select;
    @NotNull
    private final String findAll;
    @NotNull
    private final String findByRole;

    public RoleRepositoryImpl(@NotNull JdbcOperations jdbcOperations) {
        Intrinsics.checkNotNullParameter((Object)jdbcOperations, (String)"jdbcOperations");
        this.jdbcOperations = jdbcOperations;
        this.table = "archimedes_security_role";
        this.insert = "INSERT INTO " + this.table + "(name) VALUES (?)";
        this.select = "SELECT name FROM " + this.table;
        this.findAll = this.select + " ORDER BY name";
        this.findByRole = this.select + " WHERE name = ?";
    }

    @Override
    @NotNull
    public Role save(@NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Object object = this.jdbcOperations.prepareStatement(this.insert, arg_0 -> RoleRepositoryImpl.save$lambda$0(role, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026           role\n        }");
        return (Role)object;
    }

    @Override
    @NotNull
    public List<Role> findAll() {
        Object object = this.jdbcOperations.prepareStatement(this.findAll, arg_0 -> RoleRepositoryImpl.findAll$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026extractData(rs)\n        }");
        return (List)object;
    }

    @Override
    @Nullable
    public Role findByRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Object object = this.jdbcOperations.prepareStatement(this.findByRole, arg_0 -> RoleRepositoryImpl.findByRole$lambda$2(role, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026extractData(rs)\n        }");
        return (Role)CollectionsKt.singleOrNull((List)((List)object));
    }

    @Override
    @NotNull
    public List<Role> findByRoleIn(@NotNull Collection<String> roles) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        StringBuilder $this$findByRoleIn_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$findByRoleIn_u24lambda_u244.append(this.select);
        $this$findByRoleIn_u24lambda_u244.append(" WHERE name IN (");
        int n = roles.size() - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl2 = false;
            $this$findByRoleIn_u24lambda_u244.append("?,");
        }
        $this$findByRoleIn_u24lambda_u244.append("?) ORDER BY name");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String findByRoleIn = string;
        Object object = this.jdbcOperations.prepareStatement(findByRoleIn, arg_0 -> RoleRepositoryImpl.findByRoleIn$lambda$6(roles, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026extractData(rs)\n        }");
        return (List)object;
    }

    private final List<Role> extractData(ResultSet rs) {
        List roles = new ArrayList();
        while (rs.next()) {
            String string = rs.getString(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rs.getString(1)");
            roles.add(new Role(string));
        }
        return roles;
    }

    private static final Role save$lambda$0(Role $role, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)$role, (String)"$role");
        it.setString(1, $role.getName());
        it.executeUpdate();
        return $role;
    }

    private static final List findAll$lambda$1(RoleRepositoryImpl this$0, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ResultSet rs = it.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return this$0.extractData(rs);
    }

    private static final List findByRole$lambda$2(String $role, RoleRepositoryImpl this$0, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)$role, (String)"$role");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setString(1, $role);
        ResultSet rs = it.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return this$0.extractData(rs);
    }

    private static final List findByRoleIn$lambda$6(Collection $roles, RoleRepositoryImpl this$0, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)$roles, (String)"$roles");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int parameterIndex = 0;
        parameterIndex = 1;
        Iterable $this$forEach$iv = $roles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String role = (String)element$iv;
            boolean bl = false;
            int n = parameterIndex;
            parameterIndex = n + 1;
            it.setString(n, role);
        }
        ResultSet rs = it.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return this$0.extractData(rs);
    }
}

