/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.persistence.jdbc;

import io.archimedesfw.security.auth.Role;
import io.archimedesfw.security.auth.Subject;
import io.archimedesfw.security.auth.SubjectRepository;
import io.archimedesfw.security.auth.UsernamePrincipal;
import io.archimedesfw.security.auth.persistence.jdbc.MapToJsonConverter;
import io.archimedesfw.security.auth.persistence.jdbc.SubjectRoleRelationDao;
import io.micronaut.data.jdbc.runtime.JdbcOperations;
import jakarta.inject.Singleton;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/archimedesfw/security/auth/persistence/jdbc/SubjectRepositoryImpl;", "Lio/archimedesfw/security/auth/SubjectRepository;", "jdbcOperations", "Lio/micronaut/data/jdbc/runtime/JdbcOperations;", "mapToJsonConverter", "Lio/archimedesfw/security/auth/persistence/jdbc/MapToJsonConverter;", "subjectRoleRelationDao", "Lio/archimedesfw/security/auth/persistence/jdbc/SubjectRoleRelationDao;", "(Lio/micronaut/data/jdbc/runtime/JdbcOperations;Lio/archimedesfw/security/auth/persistence/jdbc/MapToJsonConverter;Lio/archimedesfw/security/auth/persistence/jdbc/SubjectRoleRelationDao;)V", "findById", "", "findByPrincipal", "insert", "select", "table", "update", "extractData", "", "Lio/archimedesfw/security/auth/Subject;", "rs", "Ljava/sql/ResultSet;", "extractGeneratedId", "", "ps", "Ljava/sql/PreparedStatement;", "extractSubject", "id", "name", "subject", "save", "setUpdateValues", "", "archimedes-security-auth-micronaut"})
public final class SubjectRepositoryImpl
implements SubjectRepository {
    @NotNull
    private final JdbcOperations jdbcOperations;
    @NotNull
    private final MapToJsonConverter mapToJsonConverter;
    @NotNull
    private final SubjectRoleRelationDao subjectRoleRelationDao;
    @NotNull
    private final String table;
    @NotNull
    private final String insert;
    @NotNull
    private final String update;
    @NotNull
    private final String select;
    @NotNull
    private final String findById;
    @NotNull
    private final String findByPrincipal;

    public SubjectRepositoryImpl(@NotNull JdbcOperations jdbcOperations, @NotNull MapToJsonConverter mapToJsonConverter, @NotNull SubjectRoleRelationDao subjectRoleRelationDao) {
        Intrinsics.checkNotNullParameter((Object)jdbcOperations, (String)"jdbcOperations");
        Intrinsics.checkNotNullParameter((Object)mapToJsonConverter, (String)"mapToJsonConverter");
        Intrinsics.checkNotNullParameter((Object)subjectRoleRelationDao, (String)"subjectRoleRelationDao");
        this.jdbcOperations = jdbcOperations;
        this.mapToJsonConverter = mapToJsonConverter;
        this.subjectRoleRelationDao = subjectRoleRelationDao;
        this.table = "archimedes_security_subject";
        this.insert = "INSERT INTO " + this.table + "(principal_name, attributes) VALUES (?, ?)";
        this.update = "UPDATE " + this.table + " SET principal_name = ?, attributes = ? WHERE id = ?";
        this.select = "SELECT id, principal_name, attributes FROM " + this.table;
        this.findById = this.select + " WHERE id = ?";
        this.findByPrincipal = this.select + " WHERE principal_name = ?";
    }

    @Override
    @NotNull
    public Subject save(@NotNull Subject subject) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Subject savedSubject = subject.getId() == -1 ? this.insert(subject) : this.update(subject);
        this.subjectRoleRelationDao.save$archimedes_security_auth_micronaut(savedSubject);
        return savedSubject;
    }

    private final Subject insert(Subject subject) {
        Object object = this.jdbcOperations.execute(arg_0 -> SubjectRepositoryImpl.insert$lambda$0(this, subject, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.execute {\u2026eneratedId(ps))\n        }");
        return (Subject)object;
    }

    private final void setUpdateValues(PreparedStatement ps, Subject subject) {
        ps.setString(1, subject.getPrincipal().getName());
        ps.setString(2, this.mapToJsonConverter.toJson$archimedes_security_auth_micronaut(subject.getAttributes()));
    }

    private final int extractGeneratedId(PreparedStatement ps) {
        ResultSet generatedKeysResultSet = ps.getGeneratedKeys();
        generatedKeysResultSet.next();
        return generatedKeysResultSet.getInt(1);
    }

    private final Subject update(Subject subject) {
        Object object = this.jdbcOperations.prepareStatement(this.update, arg_0 -> SubjectRepositoryImpl.update$lambda$1(this, subject, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026        subject\n        }");
        return (Subject)object;
    }

    @Override
    @Nullable
    public Subject findById(int id) {
        Object object = this.jdbcOperations.prepareStatement(this.findById, arg_0 -> SubjectRepositoryImpl.findById$lambda$2(id, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026extractData(rs)\n        }");
        return (Subject)CollectionsKt.singleOrNull((List)((List)object));
    }

    private final List<Subject> extractData(ResultSet rs) {
        List subjects = new ArrayList();
        while (rs.next()) {
            subjects.add(this.extractSubject(rs));
        }
        return subjects;
    }

    private final Subject extractSubject(ResultSet rs) {
        int id = rs.getInt(1);
        Set<Role> roles = this.subjectRoleRelationDao.findRolesBySubjectId$archimedes_security_auth_micronaut(id);
        String string = rs.getString(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rs.getString(2)");
        Principal principal = new UsernamePrincipal(string);
        String string2 = rs.getString(3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(3)");
        return new Subject(id, principal, roles, this.mapToJsonConverter.toMap$archimedes_security_auth_micronaut(string2));
    }

    @Override
    @Nullable
    public Subject findByPrincipal(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.jdbcOperations.prepareStatement(this.findByPrincipal, arg_0 -> SubjectRepositoryImpl.findByPrincipal$lambda$3(name, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026extractData(rs)\n        }");
        return (Subject)CollectionsKt.singleOrNull((List)((List)object));
    }

    private static final Subject insert$lambda$0(SubjectRepositoryImpl this$0, Subject $subject, Connection it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$subject, (String)"$subject");
        String[] stringArray = new String[]{"id"};
        PreparedStatement ps = it.prepareStatement(this$0.insert, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)ps, (String)"ps");
        this$0.setUpdateValues(ps, $subject);
        ps.executeUpdate();
        return Subject.copy$default($subject, this$0.extractGeneratedId(ps), null, null, null, 14, null);
    }

    private static final Subject update$lambda$1(SubjectRepositoryImpl this$0, Subject $subject, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$subject, (String)"$subject");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.setUpdateValues(it, $subject);
        it.setInt(3, $subject.getId());
        it.executeUpdate();
        return $subject;
    }

    private static final List findById$lambda$2(int $id, SubjectRepositoryImpl this$0, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setInt(1, $id);
        ResultSet rs = it.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return this$0.extractData(rs);
    }

    private static final List findByPrincipal$lambda$3(String $name, SubjectRepositoryImpl this$0, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setString(1, $name);
        ResultSet rs = it.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return this$0.extractData(rs);
    }
}

