/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.persistence.jdbc;

import io.archimedesfw.security.auth.Role;
import io.archimedesfw.security.auth.Subject;
import io.archimedesfw.security.auth.persistence.jdbc.SubjectRoleRelation;
import io.micronaut.data.jdbc.runtime.JdbcOperations;
import jakarta.inject.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0015J\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0015\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/archimedesfw/security/auth/persistence/jdbc/SubjectRoleRelationDao;", "", "jdbcOperations", "Lio/micronaut/data/jdbc/runtime/JdbcOperations;", "(Lio/micronaut/data/jdbc/runtime/JdbcOperations;)V", "deleteBySubjectId", "", "findBySubjectId", "insert", "select", "table", "", "subjectId", "", "deleteBySubjectId$archimedes_security_auth_micronaut", "extractData", "", "Lio/archimedesfw/security/auth/Role;", "rs", "Ljava/sql/ResultSet;", "findRolesBySubjectId", "findRolesBySubjectId$archimedes_security_auth_micronaut", "insertAll", "relations", "", "Lio/archimedesfw/security/auth/persistence/jdbc/SubjectRoleRelation;", "insertRelations", "subject", "Lio/archimedesfw/security/auth/Subject;", "insertRelations$archimedes_security_auth_micronaut", "save", "save$archimedes_security_auth_micronaut", "archimedes-security-auth-micronaut"})
public final class SubjectRoleRelationDao {
    @NotNull
    private final JdbcOperations jdbcOperations;
    @NotNull
    private final String table;
    @NotNull
    private final String insert;
    @NotNull
    private final String select;
    @NotNull
    private final String findBySubjectId;
    @NotNull
    private final String deleteBySubjectId;

    public SubjectRoleRelationDao(@NotNull JdbcOperations jdbcOperations) {
        Intrinsics.checkNotNullParameter((Object)jdbcOperations, (String)"jdbcOperations");
        this.jdbcOperations = jdbcOperations;
        this.table = "archimedes_security_subject_role_relation";
        this.insert = "INSERT INTO " + this.table + "(subject_id, role_name) VALUES ";
        this.select = "SELECT subject_id, role_name FROM " + this.table;
        this.findBySubjectId = this.select + " WHERE subject_id = ? ORDER BY role_name";
        this.deleteBySubjectId = "DELETE FROM " + this.table + " WHERE subject_id = ?";
    }

    public final void save$archimedes_security_auth_micronaut(@NotNull Subject subject) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        this.deleteBySubjectId$archimedes_security_auth_micronaut(subject.getId());
        this.insertRelations$archimedes_security_auth_micronaut(subject);
    }

    public final void deleteBySubjectId$archimedes_security_auth_micronaut(int subjectId) {
        this.jdbcOperations.prepareStatement(this.deleteBySubjectId, arg_0 -> SubjectRoleRelationDao.deleteBySubjectId$lambda$0(subjectId, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final void insertRelations$archimedes_security_auth_micronaut(@NotNull Subject subject) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Iterable $this$map$iv = subject.getRoles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SubjectRoleRelation(subject.getId(), it.getName()));
        }
        List relations = (List)destination$iv$iv;
        this.insertAll(relations);
    }

    private final void insertAll(List<SubjectRoleRelation> relations) {
        StringBuilder stringBuilder;
        if (relations.isEmpty()) {
            return;
        }
        StringBuilder $this$insertAll_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$insertAll_u24lambda_u243.append(this.insert);
        int n = relations.size() - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl2 = false;
            $this$insertAll_u24lambda_u243.append("(?, ?), ");
        }
        $this$insertAll_u24lambda_u243.append("(?, ?)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String insertAll = string;
        this.jdbcOperations.prepareStatement(insertAll, arg_0 -> SubjectRoleRelationDao.insertAll$lambda$5(relations, arg_0));
    }

    @NotNull
    public final Set<Role> findRolesBySubjectId$archimedes_security_auth_micronaut(int subjectId) {
        Object object = this.jdbcOperations.prepareStatement(this.findBySubjectId, arg_0 -> SubjectRoleRelationDao.findRolesBySubjectId$lambda$6(subjectId, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026extractData(rs)\n        }");
        return (Set)object;
    }

    private final Set<Role> extractData(ResultSet rs) {
        Set roles = new LinkedHashSet();
        while (rs.next()) {
            String string = rs.getString(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rs.getString(2)");
            roles.add(new Role(string));
        }
        return roles;
    }

    private static final Integer deleteBySubjectId$lambda$0(int $subjectId, PreparedStatement it) {
        it.setInt(1, $subjectId);
        return it.executeUpdate();
    }

    private static final Integer insertAll$lambda$5(List $relations, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)$relations, (String)"$relations");
        int parameterIndex = 0;
        parameterIndex = 1;
        Iterable $this$forEach$iv = $relations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SubjectRoleRelation relation = (SubjectRoleRelation)element$iv;
            boolean bl = false;
            int n = parameterIndex;
            parameterIndex = n + 1;
            it.setInt(n, relation.getSubjectId());
            n = parameterIndex;
            parameterIndex = n + 1;
            it.setString(n, relation.getRole());
        }
        return it.executeUpdate();
    }

    private static final Set findRolesBySubjectId$lambda$6(int $subjectId, SubjectRoleRelationDao this$0, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setInt(1, $subjectId);
        ResultSet rs = it.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return this$0.extractData(rs);
    }
}

