/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.token.refresh;

import io.archimedesfw.security.auth.Subject;
import io.archimedesfw.security.auth.SubjectRepository;
import io.archimedesfw.security.auth.token.refresh.RefreshToken;
import io.archimedesfw.security.auth.token.refresh.RefreshTokenAuthenticator;
import io.archimedesfw.security.auth.token.refresh.RefreshTokenCredential;
import io.archimedesfw.security.auth.token.refresh.RefreshTokenRepository;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationFailureReason;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.errors.ErrorCode;
import io.micronaut.security.errors.IssuingAnAccessTokenErrorCode;
import io.micronaut.security.errors.OauthErrorResponseException;
import jakarta.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/archimedesfw/security/auth/token/refresh/DefaultRefreshTokenAuthenticator;", "Lio/archimedesfw/security/auth/token/refresh/RefreshTokenAuthenticator;", "subjectRepository", "Lio/archimedesfw/security/auth/SubjectRepository;", "refreshTokenRepository", "Lio/archimedesfw/security/auth/token/refresh/RefreshTokenRepository;", "(Lio/archimedesfw/security/auth/SubjectRepository;Lio/archimedesfw/security/auth/token/refresh/RefreshTokenRepository;)V", "authenticate", "Lio/archimedesfw/security/auth/Subject;", "refreshToken", "Lio/archimedesfw/security/auth/token/refresh/RefreshTokenCredential;", "archimedes-security-auth-micronaut"})
public final class DefaultRefreshTokenAuthenticator
implements RefreshTokenAuthenticator {
    @NotNull
    private final SubjectRepository subjectRepository;
    @NotNull
    private final RefreshTokenRepository refreshTokenRepository;

    public DefaultRefreshTokenAuthenticator(@NotNull SubjectRepository subjectRepository, @NotNull RefreshTokenRepository refreshTokenRepository) {
        Intrinsics.checkNotNullParameter((Object)subjectRepository, (String)"subjectRepository");
        Intrinsics.checkNotNullParameter((Object)refreshTokenRepository, (String)"refreshTokenRepository");
        this.subjectRepository = subjectRepository;
        this.refreshTokenRepository = refreshTokenRepository;
    }

    @Override
    @NotNull
    public Subject authenticate(@NotNull RefreshTokenCredential refreshToken) {
        Subject subject;
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        RefreshToken refreshToken2 = this.refreshTokenRepository.findByRefreshToken(refreshToken.getSecret());
        if (refreshToken2 == null) {
            throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_GRANT);
        }
        RefreshToken token = refreshToken2;
        try {
            Subject subject2 = this.subjectRepository.findByPrincipal(token.getPrincipalName());
            if (subject2 == null) {
                throw new AuthenticationException((AuthenticationResponse)new AuthenticationFailed(AuthenticationFailureReason.USER_NOT_FOUND));
            }
            subject = subject2;
        }
        catch (Throwable th) {
            throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_GRANT);
        }
        Subject subject3 = subject;
        return subject3;
    }
}

