/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.security.auth.token.refresh.persistence.jdbc;

import io.archimedesfw.security.auth.token.refresh.RefreshToken;
import io.archimedesfw.security.auth.token.refresh.RefreshTokenRepository;
import io.micronaut.data.jdbc.runtime.JdbcOperations;
import jakarta.inject.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/archimedesfw/security/auth/token/refresh/persistence/jdbc/RefreshTokenRepositoryImpl;", "Lio/archimedesfw/security/auth/token/refresh/RefreshTokenRepository;", "jdbcOperations", "Lio/micronaut/data/jdbc/runtime/JdbcOperations;", "(Lio/micronaut/data/jdbc/runtime/JdbcOperations;)V", "deleteByPrincipalName", "", "findByRefreshToken", "insert", "select", "table", "", "name", "extractData", "", "Lio/archimedesfw/security/auth/token/refresh/RefreshToken;", "rs", "Ljava/sql/ResultSet;", "refreshToken", "save", "archimedes-security-auth-micronaut"})
public final class RefreshTokenRepositoryImpl
implements RefreshTokenRepository {
    @NotNull
    private final JdbcOperations jdbcOperations;
    @NotNull
    private final String table;
    @NotNull
    private final String insert;
    @NotNull
    private final String deleteByPrincipalName;
    @NotNull
    private final String select;
    @NotNull
    private final String findByRefreshToken;

    public RefreshTokenRepositoryImpl(@NotNull JdbcOperations jdbcOperations) {
        Intrinsics.checkNotNullParameter((Object)jdbcOperations, (String)"jdbcOperations");
        this.jdbcOperations = jdbcOperations;
        this.table = "archimedes_security_refresh_token";
        this.insert = "INSERT INTO " + this.table + "(refresh_token, principal_name) VALUES (?, ?)";
        this.deleteByPrincipalName = "DELETE FROM " + this.table + " WHERE principal_name = ?";
        this.select = "SELECT refresh_token, principal_name FROM " + this.table;
        this.findByRefreshToken = this.select + " WHERE refresh_token = ?";
    }

    @Override
    @NotNull
    public RefreshToken save(@NotNull RefreshToken refreshToken) {
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        this.deleteByPrincipalName(refreshToken.getPrincipalName());
        Object object = this.jdbcOperations.prepareStatement(this.insert, arg_0 -> RefreshTokenRepositoryImpl.save$lambda$0(refreshToken, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026   refreshToken\n        }");
        return (RefreshToken)object;
    }

    @Override
    public void deleteByPrincipalName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.jdbcOperations.prepareStatement(this.deleteByPrincipalName, arg_0 -> RefreshTokenRepositoryImpl.deleteByPrincipalName$lambda$1(name, arg_0));
    }

    @Override
    @Nullable
    public RefreshToken findByRefreshToken(@NotNull String refreshToken) {
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Object object = this.jdbcOperations.prepareStatement(this.findByRefreshToken, arg_0 -> RefreshTokenRepositoryImpl.findByRefreshToken$lambda$2(refreshToken, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdbcOperations.prepareSt\u2026extractData(rs)\n        }");
        return (RefreshToken)CollectionsKt.singleOrNull((List)((List)object));
    }

    private final List<RefreshToken> extractData(ResultSet rs) {
        List refreshTokens = new ArrayList();
        while (rs.next()) {
            String string = rs.getString(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rs.getString(1)");
            String string2 = rs.getString(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(2)");
            refreshTokens.add(new RefreshToken(string, string2));
        }
        return refreshTokens;
    }

    private static final RefreshToken save$lambda$0(RefreshToken $refreshToken, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)$refreshToken, (String)"$refreshToken");
        it.setString(1, $refreshToken.getRefreshToken());
        it.setString(2, $refreshToken.getPrincipalName());
        it.executeUpdate();
        return $refreshToken;
    }

    private static final Integer deleteByPrincipalName$lambda$1(String $name, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        it.setString(1, $name);
        return it.executeUpdate();
    }

    private static final List findByRefreshToken$lambda$2(String $refreshToken, RefreshTokenRepositoryImpl this$0, PreparedStatement it) {
        Intrinsics.checkNotNullParameter((Object)$refreshToken, (String)"$refreshToken");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setString(1, $refreshToken);
        ResultSet rs = it.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return this$0.extractData(rs);
    }
}

