/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.core.config.adapter;

import io.arconia.core.support.Internal;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Internal
public class PropertyAdapter {
    private static final Logger logger = LoggerFactory.getLogger(PropertyAdapter.class);
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(\\d+)(ms|s|m|h)$");
    private final Map<String, Object> arconiaProperties = new HashMap<String, Object>();

    public Map<String, Object> getArconiaProperties() {
        return this.arconiaProperties;
    }

    public static Builder builder(ConfigurableEnvironment environment) {
        return new Builder(environment);
    }

    public static class Builder {
        private final ConfigurableEnvironment environment;
        private final PropertyAdapter adapter;

        private Builder(ConfigurableEnvironment environment) {
            this.environment = environment;
            this.adapter = new PropertyAdapter();
        }

        public <T> Builder mapProperty(String externalKey, String arconiaKey, Function<String, T> converter) {
            T convertedValue;
            String value = this.environment.getProperty(externalKey);
            if (StringUtils.hasText((String)value) && (convertedValue = converter.apply(value.trim())) != null) {
                this.adapter.arconiaProperties.put(arconiaKey, convertedValue);
            }
            return this;
        }

        public <T> Builder mapEnum(String externalKey, String arconiaKey, Function<String, Function<String, T>> converterFactory) {
            return this.mapProperty(externalKey, arconiaKey, converterFactory.apply(externalKey));
        }

        public Builder mapBoolean(String externalKey, String arconiaKey) {
            return this.mapProperty(externalKey, arconiaKey, Boolean::valueOf);
        }

        public Builder mapInteger(String externalKey, String arconiaKey) {
            return this.mapProperty(externalKey, arconiaKey, value -> {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                    return null;
                }
            });
        }

        public Builder mapDouble(String externalKey, String arconiaKey) {
            return this.mapProperty(externalKey, arconiaKey, value -> {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                    return null;
                }
            });
        }

        public Builder mapDuration(String externalKey, String arconiaKey) {
            return this.mapProperty(externalKey, arconiaKey, value -> {
                try {
                    Matcher matcher = DURATION_PATTERN.matcher(value.trim());
                    if (matcher.matches()) {
                        String unit;
                        long amount = Long.parseLong(matcher.group(1));
                        return switch (unit = matcher.group(2)) {
                            case "ms" -> Duration.ofMillis(amount);
                            case "s" -> Duration.ofSeconds(amount);
                            case "m" -> Duration.ofMinutes(amount);
                            case "h" -> Duration.ofHours(amount);
                            default -> null;
                        };
                    }
                    return Duration.ofMillis(Long.parseLong(value.trim()));
                }
                catch (Exception e) {
                    logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                    return null;
                }
            });
        }

        public Builder mapList(String externalKey, String arconiaKey) {
            return this.mapProperty(externalKey, arconiaKey, value -> {
                List<String> propertyList = List.of(value.split(","));
                return CollectionUtils.isEmpty(propertyList) ? null : propertyList;
            });
        }

        public Builder mapMap(String externalKey, String arconiaKey) {
            return this.mapMap(externalKey, arconiaKey, null);
        }

        public Builder mapMap(String externalKey, String arconiaKey, @Nullable Function<Map<String, String>, Map<String, String>> postProcessor) {
            return this.mapProperty(externalKey, arconiaKey, value -> {
                String[] keyValuePairs;
                Map<String, String> propertyMap = new HashMap();
                for (String pair : keyValuePairs = value.split("\\s*,\\s*")) {
                    String[] entry = pair.split("=");
                    if (entry.length == 2 && StringUtils.hasText((String)entry[0]) && StringUtils.hasText((String)entry[1])) {
                        propertyMap.put(entry[0].trim(), entry[1].trim());
                        continue;
                    }
                    logger.warn("Invalid key-value pair in {}: {}", (Object)externalKey, (Object)pair);
                }
                if (postProcessor != null) {
                    propertyMap = (Map)postProcessor.apply(propertyMap);
                }
                return CollectionUtils.isEmpty(propertyMap) ? null : propertyMap;
            });
        }

        public Builder mapString(String externalKey, String arconiaKey) {
            return this.mapProperty(externalKey, arconiaKey, Function.identity());
        }

        public PropertyAdapter build() {
            return this.adapter;
        }
    }
}

