/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.core.info;

import io.arconia.core.support.Incubating;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public final class HostInfo {
    private static final Logger logger = LoggerFactory.getLogger(HostInfo.class);
    private final @Nullable String arch = System.getProperty("os.arch");
    private final @Nullable String name;

    public HostInfo() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            logger.debug("Failed to get hostname", (Throwable)ex);
        }
        this.name = hostName;
    }

    public @Nullable String getArch() {
        return this.arch;
    }

    public @Nullable String getName() {
        return this.name;
    }
}

