/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.dev.services.connections;

import io.arconia.core.support.Internal;
import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.otlp.OtlpMetricsConnectionDetails;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.otlp.OtlpMetricsExporterConfiguration;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.grafana.LgtmStackContainer;

@Internal
public class LgtmOtlpMetricsContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LgtmStackContainer, OtlpMetricsConnectionDetails> {
    LgtmOtlpMetricsContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{OtlpMetricsExporterConfiguration.class.getName()});
    }

    protected OtlpMetricsConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
        return new LgtmOtlpMetricsContainerConnectionDetails(source);
    }

    private static final class LgtmOtlpMetricsContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LgtmStackContainer>
    implements OtlpMetricsConnectionDetails {
        private LgtmOtlpMetricsContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
            super(source);
        }

        public String getUrl(Protocol protocol) {
            String url = switch (protocol) {
                default -> throw new MatchException(null, null);
                case Protocol.HTTP_PROTOBUF -> ((LgtmStackContainer)this.getContainer()).getOtlpHttpUrl();
                case Protocol.GRPC -> ((LgtmStackContainer)this.getContainer()).getOtlpGrpcUrl();
            };
            return protocol == Protocol.HTTP_PROTOBUF ? url + "/v1/metrics" : url;
        }
    }
}

