/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.dev.services.connections;

import io.arconia.core.support.Internal;
import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.sdk.traces.exporter.otlp.OtlpTracingConnectionDetails;
import io.arconia.opentelemetry.autoconfigure.sdk.traces.exporter.otlp.OtlpTracingExporterConfiguration;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.grafana.LgtmStackContainer;

@Internal
public class LgtmOtlpTracingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LgtmStackContainer, OtlpTracingConnectionDetails> {
    LgtmOtlpTracingContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{OtlpTracingExporterConfiguration.class.getName()});
    }

    protected OtlpTracingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
        return new LgtmOtlpTracingContainerConnectionDetails(source);
    }

    private static final class LgtmOtlpTracingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LgtmStackContainer>
    implements OtlpTracingConnectionDetails {
        private LgtmOtlpTracingContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
            super(source);
        }

        public String getUrl(Protocol protocol) {
            String url = switch (protocol) {
                default -> throw new MatchException(null, null);
                case Protocol.HTTP_PROTOBUF -> ((LgtmStackContainer)this.getContainer()).getOtlpHttpUrl();
                case Protocol.GRPC -> ((LgtmStackContainer)this.getContainer()).getOtlpGrpcUrl();
            };
            return protocol == Protocol.HTTP_PROTOBUF ? url + "/v1/traces" : url;
        }
    }
}

