/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.dev.services.lgtm;

import io.arconia.dev.services.lgtm.LgtmDevServicesProperties;
import io.arconia.opentelemetry.autoconfigure.sdk.ConditionalOnOpenTelemetry;
import java.time.Duration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.devtools.restart.RestartScope;
import org.springframework.boot.testcontainers.service.connection.ServiceConnection;
import org.springframework.boot.testcontainers.service.connection.ServiceConnectionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.testcontainers.grafana.LgtmStackContainer;
import org.testcontainers.utility.DockerImageName;

@AutoConfiguration(before={ServiceConnectionAutoConfiguration.class})
@ConditionalOnOpenTelemetry
@ConditionalOnProperty(prefix="arconia.dev.services.lgtm", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={LgtmDevServicesProperties.class})
@Import(value={ConfigurationWithRestart.class, ConfigurationWithoutRestart.class})
public class LgtmDevServicesAutoConfiguration {
    public static final String COMPATIBLE_IMAGE_NAME = "grafana/otel-lgtm";

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.boot.devtools.restart.RestartScope"})
    public static class ConfigurationWithoutRestart {
        @Bean
        @ServiceConnection
        @ConditionalOnMissingBean
        LgtmStackContainer lgtmContainerNoRestartScope(LgtmDevServicesProperties properties) {
            return (LgtmStackContainer)((LgtmStackContainer)((LgtmStackContainer)new LgtmStackContainer(DockerImageName.parse((String)properties.getImageName()).asCompatibleSubstituteFor(LgtmDevServicesAutoConfiguration.COMPATIBLE_IMAGE_NAME)).withEnv(properties.getEnvironment())).withStartupTimeout(Duration.ofMinutes(2L))).withReuse(properties.isReusable());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestartScope.class})
    public static class ConfigurationWithRestart {
        @Bean
        @RestartScope
        @ServiceConnection
        @ConditionalOnMissingBean
        LgtmStackContainer lgtmContainer(LgtmDevServicesProperties properties) {
            return (LgtmStackContainer)((LgtmStackContainer)((LgtmStackContainer)new LgtmStackContainer(DockerImageName.parse((String)properties.getImageName()).asCompatibleSubstituteFor(LgtmDevServicesAutoConfiguration.COMPATIBLE_IMAGE_NAME)).withEnv(properties.getEnvironment())).withStartupTimeout(Duration.ofMinutes(2L))).withReuse(properties.isReusable());
        }
    }
}

