/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.dev.services.postgresql;

import io.arconia.dev.services.postgresql.PostgresqlDevServicesProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.devtools.restart.RestartScope;
import org.springframework.boot.testcontainers.service.connection.ServiceConnection;
import org.springframework.boot.testcontainers.service.connection.ServiceConnectionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

@AutoConfiguration(before={ServiceConnectionAutoConfiguration.class})
@ConditionalOnProperty(prefix="arconia.dev.services.postgresql", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={PostgresqlDevServicesProperties.class})
@Import(value={ConfigurationWithRestart.class, ConfigurationWithoutRestart.class})
public class PostgresqlDevServicesAutoConfiguration {
    public static final String COMPATIBLE_IMAGE_NAME = "postgres";

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.boot.devtools.restart.RestartScope"})
    public static class ConfigurationWithoutRestart {
        @Bean
        @ServiceConnection
        @ConditionalOnMissingBean
        PostgreSQLContainer<?> postgresqlContainerNoRestartScope(PostgresqlDevServicesProperties properties) {
            return (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)properties.getImageName()).asCompatibleSubstituteFor(PostgresqlDevServicesAutoConfiguration.COMPATIBLE_IMAGE_NAME)).withEnv(properties.getEnvironment())).withReuse(properties.isReusable());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestartScope.class})
    public static class ConfigurationWithRestart {
        @Bean
        @RestartScope
        @ServiceConnection
        @ConditionalOnMissingBean
        PostgreSQLContainer<?> postgresqlContainer(PostgresqlDevServicesProperties properties) {
            return (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)properties.getImageName()).asCompatibleSubstituteFor(PostgresqlDevServicesAutoConfiguration.COMPATIBLE_IMAGE_NAME)).withEnv(properties.getEnvironment())).withReuse(properties.isReusable());
        }
    }
}

