/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.instrumentation;

import io.arconia.opentelemetry.autoconfigure.instrumentation.ConditionalOnOpenTelemetryInstrumentation;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnOpenTelemetryInstrumentationCondition
extends SpringBootCondition {
    private static final String GLOBAL_PROPERTY = "arconia.otel.instrumentation.enabled";
    private static final String INSTRUMENTATION_PROPERTY = "arconia.otel.instrumentation.%s.enabled";

    OnOpenTelemetryInstrumentationCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Boolean instrumentationEnabled;
        String instrumentationName = OnOpenTelemetryInstrumentationCondition.getInstrumentationName(metadata);
        if (StringUtils.hasLength((String)instrumentationName) && (instrumentationEnabled = (Boolean)context.getEnvironment().getProperty(INSTRUMENTATION_PROPERTY.formatted(instrumentationName), Boolean.class)) != null) {
            return new ConditionOutcome(instrumentationEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnOpenTelemetryInstrumentation.class, (Object[])new Object[0]).because(INSTRUMENTATION_PROPERTY.formatted(instrumentationName) + " is " + instrumentationEnabled));
        }
        Boolean globalInstrumentationEnabled = (Boolean)context.getEnvironment().getProperty(GLOBAL_PROPERTY, Boolean.class);
        if (globalInstrumentationEnabled != null) {
            return new ConditionOutcome(globalInstrumentationEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnOpenTelemetryInstrumentation.class, (Object[])new Object[0]).because("arconia.otel.instrumentation.enabled is " + globalInstrumentationEnabled));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryInstrumentation.class, (Object[])new Object[0]).because("instrumentation is enabled by default"));
    }

    private static String getInstrumentationName(AnnotatedTypeMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnOpenTelemetryInstrumentation.class.getName());
        if (attributes == null) {
            return null;
        }
        return (String)attributes.get("value");
    }
}

