/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.instrumentation.config;

import io.arconia.opentelemetry.autoconfigure.instrumentation.config.ActuatorInstrumentationPropertyAdapters;
import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

class ActuatorInstrumentationEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String PROPERTY_SOURCE_NAME = "arconia-opentelemetry-instrumentation-actuator";

    ActuatorInstrumentationEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        Boolean enabled = (Boolean)environment.getProperty("arconia.otel.compatibility.actuator", Boolean.class, (Object)false);
        if (!enabled.booleanValue()) {
            return;
        }
        HashMap arconiaProperties = new HashMap();
        arconiaProperties.putAll(ActuatorInstrumentationPropertyAdapters.metrics(environment).getArconiaProperties());
        MapPropertySource propertySource = new MapPropertySource(PROPERTY_SOURCE_NAME, arconiaProperties);
        MutablePropertySources propertySources = environment.getPropertySources();
        propertySources.addFirst((PropertySource)propertySource);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

