/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.instrumentation.config;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class ActuatorInstrumentationPropertyConverters {
    private static final Logger logger = LoggerFactory.getLogger(ActuatorInstrumentationPropertyConverters.class);

    ActuatorInstrumentationPropertyConverters() {
    }

    static Function<String, @Nullable TimeUnit> baseTimeUnit(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            TimeUnit baseTimeUnit;
            try {
                baseTimeUnit = TimeUnit.valueOf(value.trim().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return baseTimeUnit;
        };
    }
}

