/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.instrumentation.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender;
import org.jspecify.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class LogbackAppenderApplicationListener
implements GenericApplicationListener {
    private static final Class<?>[] EVENT_TYPES = new Class[]{ApplicationEnvironmentPreparedEvent.class};
    private static final Class<?>[] SOURCE_TYPES = new Class[]{ApplicationContext.class, SpringApplication.class};

    LogbackAppenderApplicationListener() {
    }

    public boolean supportsEventType(ResolvableType eventType) {
        Assert.notNull((Object)eventType, (String)"eventType cannot be null");
        return this.isAssignableFrom(eventType.getRawClass(), EVENT_TYPES);
    }

    public boolean supportsSourceType(@Nullable Class<?> sourceType) {
        return this.isAssignableFrom(sourceType, SOURCE_TYPES);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!this.shouldRegisterLogbackAppender()) {
            return;
        }
        if (!(event instanceof ApplicationEnvironmentPreparedEvent)) {
            return;
        }
        ApplicationEnvironmentPreparedEvent applicationEvent = (ApplicationEnvironmentPreparedEvent)event;
        Binder binder = Binder.get((Environment)applicationEvent.getEnvironment());
        if (!this.isOpenTelemetryEnabled(binder) || !this.isLogbackInstrumentationEnabled(binder)) {
            return;
        }
        OpenTelemetryAppender openTelemetryAppender = new OpenTelemetryAppender();
        this.configureOpenTelemetryAppender(openTelemetryAppender, binder);
        openTelemetryAppender.start();
        Logger rootLogbackLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogbackLogger.addAppender((Appender)openTelemetryAppender);
    }

    private void configureOpenTelemetryAppender(OpenTelemetryAppender openTelemetryAppender, Binder binder) {
        boolean captureArguments = (Boolean)binder.bind("arconia.otel.instrumentation.logback-appender.capture-arguments", Boolean.class).orElse((Object)false);
        openTelemetryAppender.setCaptureArguments(captureArguments);
        boolean captureCodeAttributes = (Boolean)binder.bind("arconia.otel.instrumentation.logback-appender.capture-code-attributes", Boolean.class).orElse((Object)false);
        openTelemetryAppender.setCaptureCodeAttributes(captureCodeAttributes);
        boolean captureExperimentalAttributes = (Boolean)binder.bind("arconia.otel.instrumentation.logback-appender.capture-experimental-attributes", Boolean.class).orElse((Object)false);
        openTelemetryAppender.setCaptureExperimentalAttributes(captureExperimentalAttributes);
        boolean captureKeyValuePairAttributes = (Boolean)binder.bind("arconia.otel.instrumentation.logback-appender.capture-key-value-pair-attributes", Boolean.class).orElse((Object)false);
        openTelemetryAppender.setCaptureKeyValuePairAttributes(captureKeyValuePairAttributes);
        boolean captureLoggerContext = (Boolean)binder.bind("arconia.otel.instrumentation.logback-appender.capture-logger-context", Boolean.class).orElse((Object)false);
        openTelemetryAppender.setCaptureLoggerContext(captureLoggerContext);
        boolean captureLogstashAttributes = (Boolean)binder.bind("arconia.otel.instrumentation.logback-appender.capture-logstash-attributes", Boolean.class).orElse((Object)false);
        openTelemetryAppender.setCaptureLogstashAttributes(captureLogstashAttributes);
        boolean captureMarkerAttribute = (Boolean)binder.bind("arconia.otel.instrumentation.logback-appender.capture-marker-attribute", Boolean.class).orElse((Object)false);
        openTelemetryAppender.setCaptureMarkerAttribute(captureMarkerAttribute);
        String captureMdcAttributes = (String)binder.bind("arconia.otel.instrumentation.logback-appender.capture-mdc-attributes", String.class).orElse(null);
        openTelemetryAppender.setCaptureMdcAttributes(captureMdcAttributes);
        Integer numLogsCapturedBeforeOtelInstall = (Integer)binder.bind("arconia.otel.instrumentation.logback-appender.num-logs-captured-before-otel-install", Integer.class).orElse((Object)1000);
        openTelemetryAppender.setNumLogsCapturedBeforeOtelInstall(numLogsCapturedBeforeOtelInstall.intValue());
    }

    private boolean isAssignableFrom(@Nullable Class<?> type, Class<?> ... supportedTypes) {
        if (type != null) {
            for (Class<?> supportedType : supportedTypes) {
                if (!supportedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldRegisterLogbackAppender() {
        return this.isLogbackPresent() && this.isOpenTelemetryPresent() && this.isLogbackAppenderPresent();
    }

    private boolean isLogbackPresent() {
        return ClassUtils.isPresent((String)"ch.qos.logback.core.Appender", null);
    }

    private boolean isOpenTelemetryPresent() {
        return ClassUtils.isPresent((String)"io.opentelemetry.api.OpenTelemetry", null);
    }

    private boolean isLogbackAppenderPresent() {
        return ClassUtils.isPresent((String)"io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender", null);
    }

    private boolean isLogbackInstrumentationEnabled(Binder binder) {
        return (Boolean)binder.bind("arconia.otel.instrumentation.logback-appender.enabled", Boolean.class).orElse((Object)true);
    }

    private boolean isOpenTelemetryEnabled(Binder binder) {
        return (Boolean)binder.bind("arconia.opentelemetry.enabled", Boolean.class).orElse((Object)true);
    }

    public int getOrder() {
        return -2147483627;
    }
}

