/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.instrumentation.logback;

import ch.qos.logback.core.Appender;
import io.arconia.opentelemetry.autoconfigure.instrumentation.ConditionalOnOpenTelemetryInstrumentation;
import io.arconia.opentelemetry.autoconfigure.instrumentation.logback.LogbackAppenderProperties;
import io.arconia.opentelemetry.autoconfigure.sdk.OpenTelemetryAutoConfiguration;
import io.arconia.opentelemetry.autoconfigure.sdk.logs.ConditionalOnOpenTelemetryLogging;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={OpenTelemetryAutoConfiguration.class})
@ConditionalOnClass(value={Appender.class})
@ConditionalOnOpenTelemetryLogging
@ConditionalOnOpenTelemetryInstrumentation(value="logback-appender")
@ConditionalOnProperty(prefix="arconia.otel.logs.exporter", name={"type"}, havingValue="otlp", matchIfMissing=true)
@EnableConfigurationProperties(value={LogbackAppenderProperties.class})
public class LogbackAppenderInstrumentationAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={OpenTelemetry.class})
    ApplicationListener<ApplicationReadyEvent> logbackAppenderOnReady(OpenTelemetry openTelemetry) {
        return event -> OpenTelemetryAppender.install((OpenTelemetry)openTelemetry);
    }

    @Bean
    @ConditionalOnBean(value={OpenTelemetry.class})
    ApplicationListener<ApplicationFailedEvent> logbackAppenderOnFailed(OpenTelemetry openTelemetry) {
        return event -> OpenTelemetryAppender.install((OpenTelemetry)openTelemetry);
    }
}

