/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.instrumentation.micrometer;

import io.arconia.opentelemetry.autoconfigure.instrumentation.ConditionalOnOpenTelemetryInstrumentation;
import io.arconia.opentelemetry.autoconfigure.instrumentation.micrometer.MicrometerProperties;
import io.arconia.opentelemetry.autoconfigure.sdk.OpenTelemetryAutoConfiguration;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.ConditionalOnOpenTelemetryMetrics;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@AutoConfiguration(after={MetricsAutoConfiguration.class, OpenTelemetryAutoConfiguration.class}, before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnOpenTelemetryMetrics
@ConditionalOnOpenTelemetryInstrumentation(value="micrometer")
@Conditional(value={MetricsExportEnabled.class})
@EnableConfigurationProperties(value={MicrometerProperties.class})
public class MicrometerInstrumentationAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={Clock.class, OpenTelemetry.class})
    MeterRegistry meterRegistry(MicrometerProperties properties, Clock clock, OpenTelemetry openTelemetry) {
        return OpenTelemetryMeterRegistry.builder((OpenTelemetry)openTelemetry).setBaseTimeUnit(properties.getBaseTimeUnit()).setClock(clock).setMicrometerHistogramGaugesEnabled(properties.isHistogramGauges()).setPrometheusMode(false).build();
    }

    static class MetricsExportEnabled
    extends AnyNestedCondition {
        MetricsExportEnabled() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="arconia.otel.metrics.exporter", name={"type"}, havingValue="otlp", matchIfMissing=true)
        static class OtlpMetricsExportEnabled {
            OtlpMetricsExportEnabled() {
            }
        }

        @ConditionalOnProperty(prefix="arconia.otel.metrics.exporter", name={"type"}, havingValue="console")
        static class ConsoleMetricsExportEnabled {
            ConsoleMetricsExportEnabled() {
            }
        }
    }
}

