/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.instrumentation.resource;

import io.arconia.opentelemetry.autoconfigure.sdk.ConditionalOnOpenTelemetry;
import io.arconia.opentelemetry.autoconfigure.sdk.resource.ConditionalOnOpenTelemetryResourceContributor;
import io.arconia.opentelemetry.autoconfigure.sdk.resource.OpenTelemetryResourceAutoConfiguration;
import io.arconia.opentelemetry.autoconfigure.sdk.resource.contributor.ResourceContributor;
import io.opentelemetry.instrumentation.resources.ContainerResource;
import io.opentelemetry.instrumentation.resources.HostIdResource;
import io.opentelemetry.sdk.resources.Resource;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration(before={OpenTelemetryResourceAutoConfiguration.class})
@ConditionalOnClass(value={Resource.class})
@ConditionalOnOpenTelemetry
public class ResourceInstrumentationAutoConfiguration {
    @Bean
    @ConditionalOnOpenTelemetryResourceContributor(value="container")
    @ConditionalOnClass(value={ContainerResource.class})
    @Order(value=-2147483638)
    ResourceContributor containerResourceContributor() {
        return builder -> builder.putAll(ContainerResource.get().getAttributes());
    }

    @Bean
    @ConditionalOnOpenTelemetryResourceContributor(value="host-id")
    @ConditionalOnClass(value={HostIdResource.class})
    @Order(value=-2147483638)
    ResourceContributor hostIdResourceContributor() {
        return builder -> builder.putAll(HostIdResource.get().getAttributes());
    }
}

