/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.micrometer.registry.otlp.autoconfigure;

import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.HistogramFlavor;
import io.micrometer.registry.otlp.OtlpConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

class MicrometerOtlpConfig
implements OtlpConfig {
    private final boolean enabled;
    private final String url;
    private final Duration step;
    private final AggregationTemporality aggregationTemporality;
    private final HistogramFlavor histogramFlavor;
    private final Map<String, String> headers;
    private final Map<String, String> resourceAttributes;
    private final int maxScale;
    private final int maxBucketCount;
    private final TimeUnit baseTimeUnit;

    private MicrometerOtlpConfig(Builder builder) {
        Assert.hasText((String)builder.url, (String)"url cannot be null or empty");
        this.enabled = builder.enabled;
        this.url = builder.url;
        this.step = builder.step;
        this.aggregationTemporality = builder.aggregationTemporality;
        this.histogramFlavor = builder.histogramFlavor;
        this.headers = builder.headers;
        this.resourceAttributes = builder.resourceAttributes;
        this.maxScale = builder.maxScale;
        this.maxBucketCount = builder.maxBucketCount;
        this.baseTimeUnit = builder.baseTimeUnit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public @Nullable String get(String key) {
        return null;
    }

    public String prefix() {
        return "arconia.otel.exporter.otlp.micrometer";
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String url() {
        return this.url;
    }

    public Duration step() {
        return this.step;
    }

    public Map<String, String> resourceAttributes() {
        return this.resourceAttributes;
    }

    public AggregationTemporality aggregationTemporality() {
        return this.aggregationTemporality;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public HistogramFlavor histogramFlavor() {
        return this.histogramFlavor;
    }

    public Map<String, HistogramFlavor> histogramFlavorPerMeter() {
        return super.histogramFlavorPerMeter();
    }

    public int maxScale() {
        return this.maxScale;
    }

    public int maxBucketCount() {
        return this.maxBucketCount;
    }

    public Map<String, Integer> maxBucketsPerMeter() {
        return super.maxBucketsPerMeter();
    }

    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    public Validated<?> validate() {
        return Validated.none();
    }

    static class Builder {
        private boolean enabled = true;
        private String url;
        private Duration step = Duration.ofSeconds(60L);
        private AggregationTemporality aggregationTemporality = AggregationTemporality.CUMULATIVE;
        private HistogramFlavor histogramFlavor = HistogramFlavor.EXPLICIT_BUCKET_HISTOGRAM;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> resourceAttributes = new HashMap<String, String>();
        private int maxScale = 20;
        private int maxBucketCount = 160;
        private TimeUnit baseTimeUnit = TimeUnit.MILLISECONDS;

        private Builder() {
        }

        Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        Builder url(String url) {
            this.url = url;
            return this;
        }

        Builder step(Duration step) {
            Assert.notNull((Object)step, (String)"step cannot be null");
            this.step = step;
            return this;
        }

        Builder aggregationTemporality(AggregationTemporality aggregationTemporality) {
            Assert.notNull((Object)aggregationTemporality, (String)"aggregationTemporality cannot be null");
            this.aggregationTemporality = aggregationTemporality;
            return this;
        }

        Builder histogramFlavor(HistogramFlavor histogramFlavor) {
            Assert.notNull((Object)histogramFlavor, (String)"histogramFlavor cannot be null");
            this.histogramFlavor = histogramFlavor;
            return this;
        }

        Builder addHeaders(Map<String, String> headers) {
            Assert.notNull(headers, (String)"headers cannot be null");
            Assert.noNullElements((Object[])headers.keySet().toArray(), (String)"headers cannot contain null keys");
            this.headers.putAll(new HashMap<String, String>(headers));
            return this;
        }

        Builder addResourceAttributes(Map<String, String> resourceAttributes) {
            Assert.notNull(resourceAttributes, (String)"resourceAttributes cannot be null");
            Assert.noNullElements((Object[])resourceAttributes.keySet().toArray(), (String)"resourceAttributes cannot contain null keys");
            this.resourceAttributes.putAll(new HashMap<String, String>(resourceAttributes));
            return this;
        }

        Builder maxScale(int maxScale) {
            this.maxScale = maxScale;
            return this;
        }

        Builder maxBucketCount(int maxBucketCount) {
            this.maxBucketCount = maxBucketCount;
            return this;
        }

        Builder baseTimeUnit(TimeUnit baseTimeUnit) {
            Assert.notNull((Object)((Object)baseTimeUnit), (String)"baseTimeUnit cannot be null");
            this.baseTimeUnit = baseTimeUnit;
            return this;
        }

        MicrometerOtlpConfig build() {
            return new MicrometerOtlpConfig(this);
        }
    }
}

