/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.micrometer.registry.otlp.autoconfigure;

import io.arconia.opentelemetry.autoconfigure.exporter.OpenTelemetryExporterProperties;
import io.arconia.opentelemetry.autoconfigure.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.metrics.OpenTelemetryMetricsAutoConfiguration;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.AggregationTemporalityStrategy;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.ConditionalOnOpenTelemetryMetricsExporter;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.HistogramAggregationStrategy;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.OpenTelemetryMetricsExporterAutoConfiguration;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.OpenTelemetryMetricsExporterProperties;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.otlp.OtlpMetricsConnectionDetails;
import io.arconia.opentelemetry.autoconfigure.resource.OpenTelemetryResourceAutoConfiguration;
import io.arconia.opentelemetry.micrometer.registry.otlp.autoconfigure.MicrometerOtlpConfig;
import io.arconia.opentelemetry.micrometer.registry.otlp.autoconfigure.MicrometerRegistryOtlpProperties;
import io.micrometer.core.instrument.Clock;
import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.HistogramFlavor;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpMeterRegistry;
import io.micrometer.registry.otlp.OtlpMetricsSender;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.VirtualThreadTaskExecutor;

@AutoConfiguration(after={MetricsAutoConfiguration.class, OpenTelemetryMetricsAutoConfiguration.class, OpenTelemetryMetricsExporterAutoConfiguration.class, OpenTelemetryResourceAutoConfiguration.class}, before={OtlpMetricsExportAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnProperties(value={@ConditionalOnProperty(prefix="arconia.otel.metrics.micrometer-bridge", name={"enabled"}, havingValue="false", matchIfMissing=true), @ConditionalOnProperty(prefix="arconia.otel.exporter.otlp.micrometer", name={"enabled"}, havingValue="true", matchIfMissing=true)})
@ConditionalOnOpenTelemetryMetricsExporter(value="otlp")
@EnableConfigurationProperties(value={MicrometerRegistryOtlpProperties.class})
public final class MicrometerRegistryOtlpAutoConfiguration {
    private static final Set<String> RESERVED_RESOURCE_ATTRIBUTES = new HashSet<String>(Arrays.asList("telemetry.sdk.language", "telemetry.sdk.name", "telemetry.sdk.version"));

    @Bean
    @ConditionalOnMissingBean
    MicrometerOtlpConfig otlpConfig(OtlpMetricsConnectionDetails connectionDetails, OpenTelemetryExporterProperties commonProperties, OpenTelemetryMetricsExporterProperties metricsProperties, MicrometerRegistryOtlpProperties registryProperties, Resource resource) {
        Protocol protocol = metricsProperties.getOtlp().getProtocol() != null ? metricsProperties.getOtlp().getProtocol() : commonProperties.getOtlp().getProtocol();
        MicrometerOtlpConfig.Builder builder = MicrometerOtlpConfig.builder().url(connectionDetails.getUrl(protocol)).step(metricsProperties.getInterval());
        MicrometerOtlpConfig.Builder builder2 = builder.aggregationTemporality(switch (metricsProperties.getAggregationTemporality()) {
            default -> throw new MatchException(null, null);
            case AggregationTemporalityStrategy.DELTA -> AggregationTemporality.DELTA;
            case AggregationTemporalityStrategy.CUMULATIVE, AggregationTemporalityStrategy.LOW_MEMORY -> AggregationTemporality.CUMULATIVE;
        });
        return builder2.histogramFlavor(switch (metricsProperties.getHistogramAggregation()) {
            default -> throw new MatchException(null, null);
            case HistogramAggregationStrategy.EXPLICIT_BUCKET_HISTOGRAM -> HistogramFlavor.EXPLICIT_BUCKET_HISTOGRAM;
            case HistogramAggregationStrategy.BASE2_EXPONENTIAL_BUCKET_HISTOGRAM -> HistogramFlavor.BASE2_EXPONENTIAL_BUCKET_HISTOGRAM;
        }).addHeaders(commonProperties.getOtlp().getHeaders()).addHeaders(metricsProperties.getOtlp().getHeaders()).addResourceAttributes(resource.getAttributes().asMap().entrySet().stream().filter(entry -> !RESERVED_RESOURCE_ATTRIBUTES.contains(((AttributeKey)entry.getKey()).getKey())).collect(HashMap::new, (m, e) -> m.put(((AttributeKey)e.getKey()).getKey(), e.getValue().toString()), HashMap::putAll)).maxScale(registryProperties.getMaxScale()).maxBucketCount(registryProperties.getMaxBucketCount()).baseTimeUnit(registryProperties.getBaseTimeUnit()).build();
    }

    @Bean
    @ConditionalOnThreading(value=Threading.PLATFORM)
    OtlpMeterRegistry otlpMeterRegistryPlatformThreads(Clock clock, OtlpConfig otlpConfig, ObjectProvider<OtlpMetricsSender> otlpMetricsSender) {
        OtlpMeterRegistry.Builder builder = OtlpMeterRegistry.builder((OtlpConfig)otlpConfig).clock(clock);
        otlpMetricsSender.ifAvailable(arg_0 -> ((OtlpMeterRegistry.Builder)builder).metricsSender(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    OtlpMeterRegistry otlpMeterRegistryVirtualThreads(Clock clock, OtlpConfig otlpConfig, ObjectProvider<OtlpMetricsSender> otlpMetricsSender) {
        VirtualThreadTaskExecutor executor = new VirtualThreadTaskExecutor("otlp-meter-registry-");
        OtlpMeterRegistry.Builder builder = OtlpMeterRegistry.builder((OtlpConfig)otlpConfig).clock(clock).threadFactory(executor.getVirtualThreadFactory());
        otlpMetricsSender.ifAvailable(arg_0 -> ((OtlpMeterRegistry.Builder)builder).metricsSender(arg_0));
        return builder.build();
    }
}

