/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.config;

import io.arconia.core.config.adapter.PropertyAdapter;
import io.arconia.opentelemetry.autoconfigure.sdk.config.ActuatorPropertyConverters;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;

class ActuatorPropertyAdapters {
    ActuatorPropertyAdapters() {
    }

    static PropertyAdapter resource(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapMap("management.opentelemetry.resource-attributes", "arconia.otel.resource.attributes").build();
    }

    static PropertyAdapter logs(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapBoolean("management.otlp.logging.export.enabled", "arconia.otel.logs.enabled").mapEnum("management.otlp.logging.transport", "arconia.otel.logs.exporter.otlp.protocol", ActuatorPropertyConverters::protocol).mapString("management.otlp.logging.endpoint", "arconia.otel.logs.exporter.otlp.endpoint").mapMap("management.otlp.logging.headers", "arconia.otel.logs.exporter.otlp.headers").mapEnum("management.otlp.logging.compression", "arconia.otel.logs.exporter.otlp.compression", ActuatorPropertyConverters::compression).mapDuration("management.otlp.logging.timeout", "arconia.otel.logs.exporter.otlp.timeout").build();
    }

    static PropertyAdapter metrics(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapBoolean("management.otlp.metrics.export.enabled", "arconia.otel.metrics.enabled").mapEnum("management.otlp.metrics.export.aggregation-temporality", "arconia.otel.metrics.exporter.aggregation-temporality", ActuatorPropertyConverters::aggregationTemporality).mapMap("management.otlp.metrics.export.headers", "arconia.otel.metrics.exporter.otlp.headers").mapEnum("management.otlp.metrics.export.histogram-flavor", "arconia.otel.metrics.exporter.histogram-aggregation", ActuatorPropertyConverters::histogramAggregation).mapDuration("management.otlp.metrics.export.read-timeout", "arconia.otel.metrics.exporter.otlp.timeout").mapDuration("management.otlp.metrics.export.step", "arconia.otel.metrics.interval").mapString("management.otlp.metrics.export.url", "arconia.otel.metrics.exporter.otlp.endpoint").build();
    }

    static PropertyAdapter traces(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapBoolean("management.otlp.tracing.export.enabled", "arconia.otel.traces.enabled").mapEnum("management.otlp.tracing.transport", "arconia.otel.traces.exporter.otlp.protocol", ActuatorPropertyConverters::protocol).mapString("management.otlp.tracing.endpoint", "arconia.otel.traces.exporter.otlp.endpoint").mapMap("management.otlp.tracing.headers", "arconia.otel.traces.exporter.otlp.headers").mapEnum("management.otlp.tracing.compression", "arconia.otel.traces.exporter.otlp.compression", ActuatorPropertyConverters::compression).mapDuration("management.otlp.tracing.timeout", "arconia.otel.traces.exporter.otlp.timeout").build();
    }
}

