/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.config;

import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Compression;
import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.AggregationTemporalityStrategy;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.HistogramAggregationStrategy;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class ActuatorPropertyConverters {
    private static final Logger logger = LoggerFactory.getLogger(ActuatorPropertyConverters.class);

    ActuatorPropertyConverters() {
    }

    static Function<String, @Nullable Protocol> protocol(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            Protocol protocol;
            switch (value.trim().toLowerCase()) {
                case "grpc": {
                    Protocol protocol2 = Protocol.GRPC;
                    break;
                }
                case "http": {
                    Protocol protocol2 = Protocol.HTTP_PROTOBUF;
                    break;
                }
                default: {
                    Protocol protocol2 = protocol = null;
                }
            }
            if (protocol == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return protocol;
        };
    }

    static Function<String, @Nullable Compression> compression(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            Compression compression;
            switch (value.trim().toLowerCase()) {
                case "gzip": {
                    Compression compression2 = Compression.GZIP;
                    break;
                }
                case "none": {
                    Compression compression2 = Compression.NONE;
                    break;
                }
                default: {
                    Compression compression2 = compression = null;
                }
            }
            if (compression == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return compression;
        };
    }

    static Function<String, @Nullable HistogramAggregationStrategy> histogramAggregation(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            HistogramAggregationStrategy histogramAggregation;
            switch (value.trim().toUpperCase()) {
                case "BASE2_EXPONENTIAL_BUCKET_HISTOGRAM": {
                    HistogramAggregationStrategy histogramAggregationStrategy = HistogramAggregationStrategy.BASE2_EXPONENTIAL_BUCKET_HISTOGRAM;
                    break;
                }
                case "EXPLICIT_BUCKET_HISTOGRAM": {
                    HistogramAggregationStrategy histogramAggregationStrategy = HistogramAggregationStrategy.EXPLICIT_BUCKET_HISTOGRAM;
                    break;
                }
                default: {
                    HistogramAggregationStrategy histogramAggregationStrategy = histogramAggregation = null;
                }
            }
            if (histogramAggregation == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return histogramAggregation;
        };
    }

    static Function<String, @Nullable AggregationTemporalityStrategy> aggregationTemporality(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            AggregationTemporalityStrategy aggregationTemporality;
            switch (value.trim().toUpperCase()) {
                case "CUMULATIVE": {
                    AggregationTemporalityStrategy aggregationTemporalityStrategy = AggregationTemporalityStrategy.CUMULATIVE;
                    break;
                }
                case "DELTA": {
                    AggregationTemporalityStrategy aggregationTemporalityStrategy = AggregationTemporalityStrategy.DELTA;
                    break;
                }
                default: {
                    AggregationTemporalityStrategy aggregationTemporalityStrategy = aggregationTemporality = null;
                }
            }
            if (aggregationTemporality == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return aggregationTemporality;
        };
    }
}

